/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetaUtils {
    private static final Map<Class, Map<String, Field>> classMetaCache = new ConcurrentHashMap<Class, Map<String, Field>>();
    private static final Set<Class> prims = new HashSet<Class>();
    private static final Map<String, Class> nameToClass = new HashMap<String, Class>();
    private static final Byte[] byteCache = new Byte[256];
    private static final Character[] charCache = new Character[128];
    private static final Pattern extraQuotes = Pattern.compile("([\"]*)([^\"]*)([\"]*)");
    private static final Class[] emptyClassArray = new Class[0];
    private static final ConcurrentMap<Class, Object[]> constructors = new ConcurrentHashMap<Class, Object[]>();
    private static final Collection unmodifiableCollection = Collections.unmodifiableCollection(new ArrayList());
    private static final Collection unmodifiableSet = Collections.unmodifiableSet(new HashSet());
    private static final Collection unmodifiableSortedSet = Collections.unmodifiableSortedSet(new TreeSet());
    private static final Map unmodifiableMap = Collections.unmodifiableMap(new HashMap());
    private static final Map unmodifiableSortedMap = Collections.unmodifiableSortedMap(new TreeMap());
    static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        }
    };
    private static boolean useUnsafe = false;
    private static Unsafe unsafe;

    static {
        prims.add(Byte.class);
        prims.add(Integer.class);
        prims.add(Long.class);
        prims.add(Double.class);
        prims.add(Character.class);
        prims.add(Float.class);
        prims.add(Boolean.class);
        prims.add(Short.class);
        nameToClass.put("string", String.class);
        nameToClass.put("boolean", Boolean.TYPE);
        nameToClass.put("char", Character.TYPE);
        nameToClass.put("byte", Byte.TYPE);
        nameToClass.put("short", Short.TYPE);
        nameToClass.put("int", Integer.TYPE);
        nameToClass.put("long", Long.TYPE);
        nameToClass.put("float", Float.TYPE);
        nameToClass.put("double", Double.TYPE);
        nameToClass.put("date", java.util.Date.class);
        nameToClass.put("class", Class.class);
        int i = 0;
        while (i < byteCache.length) {
            MetaUtils.byteCache[i] = (byte)(i - 128);
            ++i;
        }
        i = 0;
        while (i < charCache.length) {
            MetaUtils.charCache[i] = Character.valueOf((char)i);
            ++i;
        }
    }

    public static void setUseUnsafe(boolean state) {
        useUnsafe = state;
        if (state) {
            try {
                unsafe = new Unsafe();
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                useUnsafe = false;
            }
        }
    }

    public static Field getField(Class c, String field) {
        return MetaUtils.getDeepDeclaredFields(c).get(field);
    }

    public static Map<String, Field> getDeepDeclaredFields(Class c) {
        Map<String, Field> classFields = classMetaCache.get(c);
        if (classFields != null) {
            return classFields;
        }
        classFields = new LinkedHashMap<String, Field>();
        Class curr = c;
        while (curr != null) {
            try {
                Field[] local;
                Field[] fieldArray = local = curr.getDeclaredFields();
                int n = local.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!((field.getModifiers() & 8) != 0 || "metaClass".equals(field.getName()) && "groovy.lang.MetaClass".equals(field.getType().getName()))) {
                        if (!field.isAccessible()) {
                            try {
                                field.setAccessible(true);
                            }
                            catch (Exception exception) {}
                        }
                        if (classFields.containsKey(field.getName())) {
                            classFields.put(String.valueOf(curr.getName()) + '.' + field.getName(), field);
                        } else {
                            classFields.put(field.getName(), field);
                        }
                    }
                    ++n2;
                }
            }
            catch (ThreadDeath t) {
                throw t;
            }
            catch (Throwable throwable) {}
            curr = curr.getSuperclass();
        }
        classMetaCache.put(c, classFields);
        return classFields;
    }

    public static int getDistance(Class a, Class b) {
        if (a.isInterface()) {
            return MetaUtils.getDistanceToInterface(a, b);
        }
        Class curr = b;
        int distance = 0;
        while (curr != a) {
            ++distance;
            if ((curr = curr.getSuperclass()) != null) continue;
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    /*
     * WARNING - void declaration
     */
    static int getDistanceToInterface(Class<?> to, Class<?> from) {
        void var5_9;
        Class<?>[] interfaces;
        LinkedHashSet possibleCandidates = new LinkedHashSet();
        Class<?>[] classArray = interfaces = from.getInterfaces();
        int n = interfaces.length;
        boolean n2 = false;
        while (var5_9 < n) {
            Class<?> interfase = classArray[var5_9];
            if (to.equals(interfase)) {
                return 1;
            }
            if (to.isAssignableFrom(interfase)) {
                possibleCandidates.add(interfase);
            }
            ++var5_9;
        }
        if (from.getSuperclass() != null && to.isAssignableFrom(from.getSuperclass())) {
            possibleCandidates.add(from.getSuperclass());
        }
        int minimum = Integer.MAX_VALUE;
        for (Class clazz : possibleCandidates) {
            int distance = MetaUtils.getDistanceToInterface(to, clazz);
            if (distance >= minimum) continue;
            minimum = ++distance;
        }
        return minimum;
    }

    public static boolean isPrimitive(Class c) {
        return c.isPrimitive() || prims.contains(c);
    }

    public static boolean isLogicalPrimitive(Class c) {
        return c.isPrimitive() || prims.contains(c) || String.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || java.util.Date.class.isAssignableFrom(c) || c.equals(Class.class);
    }

    static Class classForName(String name) {
        try {
            if (name == null || name.isEmpty()) {
                throw new JsonIoException("Class name cannot be null or empty.");
            }
            Class c = nameToClass.get(name);
            try {
                return c == null ? MetaUtils.loadClass(name) : c;
            }
            catch (Exception e) {
                throw new JsonIoException("Class not found: " + name, e);
            }
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to create class: " + name, e);
        }
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        String className = name;
        boolean arrayType = false;
        Class<Object> primitiveArray = null;
        while (className.startsWith("[")) {
            arrayType = true;
            if (className.endsWith(";")) {
                className = className.substring(0, className.length() - 1);
            }
            if (className.equals("[B")) {
                primitiveArray = byte[].class;
            } else if (className.equals("[S")) {
                primitiveArray = short[].class;
            } else if (className.equals("[I")) {
                primitiveArray = int[].class;
            } else if (className.equals("[J")) {
                primitiveArray = long[].class;
            } else if (className.equals("[F")) {
                primitiveArray = float[].class;
            } else if (className.equals("[D")) {
                primitiveArray = double[].class;
            } else if (className.equals("[Z")) {
                primitiveArray = boolean[].class;
            } else if (className.equals("[C")) {
                primitiveArray = char[].class;
            }
            int startpos = className.startsWith("[L") ? 2 : 1;
            className = className.substring(startpos);
        }
        Class<?> currentClass = null;
        if (primitiveArray == null) {
            currentClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        if (arrayType) {
            currentClass = primitiveArray != null ? primitiveArray : Array.newInstance(currentClass, 0).getClass();
            while (name.startsWith("[[")) {
                currentClass = Array.newInstance(currentClass, 0).getClass();
                name = name.substring(1);
            }
        }
        return currentClass;
    }

    static Character valueOf(char c) {
        return Character.valueOf(c <= '\u007f' ? charCache[c].charValue() : c);
    }

    static String removeLeadingAndTrailingQuotes(String s) {
        Matcher m = extraQuotes.matcher(s);
        if (m.find()) {
            s = m.group(2);
        }
        return s;
    }

    static Object newInstance(Class c) {
        if (unmodifiableSortedMap.getClass().isAssignableFrom(c)) {
            return new TreeMap();
        }
        if (unmodifiableMap.getClass().isAssignableFrom(c)) {
            return new LinkedHashMap();
        }
        if (unmodifiableSortedSet.getClass().isAssignableFrom(c)) {
            return new TreeSet();
        }
        if (unmodifiableSet.getClass().isAssignableFrom(c)) {
            return new LinkedHashSet();
        }
        if (unmodifiableCollection.getClass().isAssignableFrom(c)) {
            return new ArrayList();
        }
        Object[] constructorInfo = (Object[])constructors.get(c);
        if (constructorInfo != null) {
            Constructor constructor = (Constructor)constructorInfo[0];
            if (constructor == null && useUnsafe) {
                try {
                    return unsafe.allocateInstance(c);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            if (constructor == null) {
                throw new JsonIoException("No constructor found to instantiate " + c.getName());
            }
            Boolean useNull = (Boolean)constructorInfo[1];
            Class[] paramTypes = constructor.getParameterTypes();
            if (paramTypes == null || paramTypes.length == 0) {
                try {
                    return constructor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new JsonIoException("Could not instantiate " + c.getName(), e);
                }
            }
            Object[] values = MetaUtils.fillArgs(paramTypes, useNull);
            try {
                return constructor.newInstance(values);
            }
            catch (Exception e) {
                throw new JsonIoException("Could not instantiate " + c.getName(), e);
            }
        }
        Object[] ret = MetaUtils.newInstanceEx(c);
        constructors.put(c, new Object[]{ret[1], ret[2]});
        return ret[0];
    }

    static Object[] newInstanceEx(Class c) {
        try {
            Constructor constructor = c.getConstructor(emptyClassArray);
            if (constructor != null) {
                return new Object[]{constructor.newInstance(new Object[0]), constructor, true};
            }
            return MetaUtils.tryOtherConstruction(c);
        }
        catch (Exception exception) {
            return MetaUtils.tryOtherConstruction(c);
        }
    }

    static Object[] tryOtherConstruction(Class c) {
        Object[] values;
        Class[] argTypes;
        Constructor<?> constructor;
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        if (constructors.length == 0) {
            throw new JsonIoException("Cannot instantiate '" + c.getName() + "' - Primitive, interface, array[] or void");
        }
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, true);
            try {
                return new Object[]{constructor.newInstance(values), constructor, true};
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        constructorArray = constructors;
        n = constructors.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            constructor.setAccessible(true);
            argTypes = constructor.getParameterTypes();
            values = MetaUtils.fillArgs(argTypes, false);
            try {
                return new Object[]{constructor.newInstance(values), constructor, false};
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        if (useUnsafe) {
            try {
                Object[] objectArray = new Object[3];
                objectArray[0] = unsafe.allocateInstance(c);
                return objectArray;
            }
            catch (Exception exception) {}
        }
        throw new JsonIoException("Could not instantiate " + c.getName() + " using any constructor");
    }

    static Object[] fillArgs(Class[] argTypes, boolean useNull) {
        Object[] values = new Object[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            Class argType = argTypes[i];
            if (MetaUtils.isPrimitive(argType)) {
                values[i] = MetaUtils.newPrimitiveWrapper(argType, null);
            } else if (useNull) {
                values[i] = null;
            } else if (argType == String.class) {
                values[i] = "";
            } else if (argType == java.util.Date.class) {
                values[i] = new java.util.Date();
            } else if (List.class.isAssignableFrom(argType)) {
                values[i] = new ArrayList();
            } else if (SortedSet.class.isAssignableFrom(argType)) {
                values[i] = new TreeSet();
            } else if (Set.class.isAssignableFrom(argType)) {
                values[i] = new LinkedHashSet();
            } else if (SortedMap.class.isAssignableFrom(argType)) {
                values[i] = new TreeMap();
            } else if (Map.class.isAssignableFrom(argType)) {
                values[i] = new LinkedHashMap();
            } else if (Collection.class.isAssignableFrom(argType)) {
                values[i] = new ArrayList();
            } else if (Calendar.class.isAssignableFrom(argType)) {
                values[i] = Calendar.getInstance();
            } else if (TimeZone.class.isAssignableFrom(argType)) {
                values[i] = TimeZone.getDefault();
            } else if (argType == BigInteger.class) {
                values[i] = BigInteger.TEN;
            } else if (argType == BigDecimal.class) {
                values[i] = BigDecimal.TEN;
            } else if (argType == StringBuilder.class) {
                values[i] = new StringBuilder();
            } else if (argType == StringBuffer.class) {
                values[i] = new StringBuffer();
            } else if (argType == Locale.class) {
                values[i] = Locale.FRANCE;
            } else if (argType == Class.class) {
                values[i] = String.class;
            } else if (argType == Timestamp.class) {
                values[i] = new Timestamp(System.currentTimeMillis());
            } else if (argType == Date.class) {
                values[i] = new Date(System.currentTimeMillis());
            } else if (argType == URL.class) {
                try {
                    values[i] = new URL("http://localhost");
                }
                catch (MalformedURLException malformedURLException) {
                    values[i] = null;
                }
            } else {
                values[i] = argType == Object.class ? new Object() : null;
            }
            ++i;
        }
        return values;
    }

    static Object newPrimitiveWrapper(Class c, Object rhs) {
        String cname;
        try {
            cname = c.getName();
            if (cname.equals("boolean") || cname.equals("java.lang.Boolean")) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "false";
                    }
                    return Boolean.parseBoolean((String)rhs);
                }
                return rhs != null ? rhs : Boolean.FALSE;
            }
            if (cname.equals("byte") || cname.equals("java.lang.Byte")) {
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "0";
                    }
                    return Byte.parseByte((String)rhs);
                }
                return rhs != null ? byteCache[((Number)rhs).byteValue() + 128] : (byte)0;
            }
            if (cname.equals("char") || cname.equals("java.lang.Character")) {
                if (rhs == null) {
                    return Character.valueOf('\u0000');
                }
                if (rhs instanceof String) {
                    if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                        rhs = "\u0000";
                    }
                    return MetaUtils.valueOf(((String)rhs).charAt(0));
                }
                if (rhs instanceof Character) {
                    return rhs;
                }
            } else {
                if (cname.equals("double") || cname.equals("java.lang.Double")) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0";
                        }
                        return Double.parseDouble((String)rhs);
                    }
                    return rhs != null ? rhs : Double.valueOf(0.0);
                }
                if (cname.equals("float") || cname.equals("java.lang.Float")) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0.0f";
                        }
                        return Float.valueOf(Float.parseFloat((String)rhs));
                    }
                    return Float.valueOf(rhs != null ? ((Number)rhs).floatValue() : 0.0f);
                }
                if (cname.equals("int") || cname.equals("java.lang.Integer")) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Integer.parseInt((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).intValue() : 0;
                }
                if (cname.equals("long") || cname.equals("java.lang.Long")) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Long.parseLong((String)rhs);
                    }
                    return rhs != null ? rhs : Long.valueOf(0L);
                }
                if (cname.equals("short") || cname.equals("java.lang.Short")) {
                    if (rhs instanceof String) {
                        if ("".equals(rhs = MetaUtils.removeLeadingAndTrailingQuotes((String)rhs))) {
                            rhs = "0";
                        }
                        return Short.parseShort((String)rhs);
                    }
                    return rhs != null ? ((Number)rhs).shortValue() : (short)0;
                }
            }
        }
        catch (Exception e) {
            String className = c == null ? "null" : c.getName();
            throw new JsonIoException("Error creating primitive wrapper instance for Class: " + className, e);
        }
        throw new JsonIoException("Class '" + cname + "' does not have primitive wrapper.");
    }

    static final class Unsafe {
        private final Object sunUnsafe;
        private final Method allocateInstance;

        public Unsafe() throws ReflectiveOperationException {
            try {
                Constructor unsafeConstructor = MetaUtils.classForName("sun.misc.Unsafe").getDeclaredConstructor(new Class[0]);
                unsafeConstructor.setAccessible(true);
                this.sunUnsafe = unsafeConstructor.newInstance(new Object[0]);
                this.allocateInstance = this.sunUnsafe.getClass().getMethod("allocateInstance", Class.class);
                this.allocateInstance.setAccessible(true);
            }
            catch (Exception e) {
                throw new ReflectiveOperationException(e);
            }
        }

        public Object allocateInstance(Class clazz) {
            try {
                return this.allocateInstance.invoke(this.sunUnsafe, clazz);
            }
            catch (IllegalAccessException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e);
            }
            catch (IllegalArgumentException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e);
            }
            catch (InvocationTargetException e) {
                String name = clazz == null ? "null" : clazz.getName();
                throw new JsonIoException("Unable to create instance of class: " + name, e.getCause() != null ? e.getCause() : e);
            }
        }
    }
}

