/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.io;

import com.cedarsoftware.util.io.JsonIoException;
import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.MetaUtils;
import com.cedarsoftware.util.io.Writers;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JsonWriter
implements Closeable,
Flushable {
    public static final String DATE_FORMAT = "DATE_FORMAT";
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd";
    public static final String ISO_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String TYPE = "TYPE";
    public static final String PRETTY_PRINT = "PRETTY_PRINT";
    public static final String FIELD_SPECIFIERS = "FIELD_SPECIFIERS";
    public static final String ENUM_PUBLIC_ONLY = "ENUM_PUBLIC_ONLY";
    public static final String WRITE_LONGS_AS_STRINGS = "WLAS";
    public static final String TYPE_NAME_MAP = "TYPE_NAME_MAP";
    public static final String SHORT_META_KEYS = "SHORT_META_KEYS";
    private static final ConcurrentMap<Class, JsonClassWriterBase> writers = new ConcurrentHashMap<Class, JsonClassWriterBase>();
    private static final Set<Class> notCustom = new HashSet<Class>();
    private static final Object[] byteStrings = new Object[256];
    private static final String newLine = System.getProperty("line.separator");
    private static final Long ZERO = 0L;
    private static final ConcurrentMap<Class, JsonClassWriterBase> writerCache = new ConcurrentHashMap<Class, JsonClassWriterBase>();
    private static final NullClass nullWriter = new NullClass();
    private final Map<Object, Long> objVisited = new IdentityHashMap<Object, Long>();
    private final Map<Object, Long> objsReferenced = new IdentityHashMap<Object, Long>();
    private final Writer out;
    private Map<String, String> typeNameMap = null;
    private boolean shortMetaKeys = false;
    long identity = 1L;
    private int depth = 0;
    static final ThreadLocal<Map<String, Object>> _args = new ThreadLocal<Map<String, Object>>(){

        @Override
        public Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    static {
        JsonWriter.addWriter(String.class, new Writers.JsonStringWriter());
        JsonWriter.addWriter(java.util.Date.class, new Writers.DateWriter());
        JsonWriter.addWriter(BigInteger.class, new Writers.BigIntegerWriter());
        JsonWriter.addWriter(BigDecimal.class, new Writers.BigDecimalWriter());
        JsonWriter.addWriter(Date.class, new Writers.DateWriter());
        JsonWriter.addWriter(Timestamp.class, new Writers.TimestampWriter());
        JsonWriter.addWriter(Calendar.class, new Writers.CalendarWriter());
        JsonWriter.addWriter(TimeZone.class, new Writers.TimeZoneWriter());
        JsonWriter.addWriter(Locale.class, new Writers.LocaleWriter());
        JsonWriter.addWriter(Class.class, new Writers.ClassWriter());
        JsonWriter.addWriter(StringBuilder.class, new Writers.StringBuilderWriter());
        JsonWriter.addWriter(StringBuffer.class, new Writers.StringBufferWriter());
        int i = -128;
        while (i <= 127) {
            char[] chars = Integer.toString(i).toCharArray();
            JsonWriter.byteStrings[i + 128] = chars;
            i = (short)(i + 1);
        }
    }

    public static String objectToJson(Object item) {
        return JsonWriter.objectToJson(item, new HashMap<String, Object>());
    }

    protected static Map getArgs() {
        return _args.get();
    }

    protected static Object getArg(String key) {
        return _args.get().get(key);
    }

    protected Map getObjectsReferenced() {
        return this.objsReferenced;
    }

    protected Map getObjectsVisited() {
        return this.objVisited;
    }

    protected String getSubstituteTypeNameIfExists(String typeName) {
        if (this.typeNameMap == null) {
            return null;
        }
        return this.typeNameMap.get(typeName);
    }

    protected String getSubstituteTypeName(String typeName) {
        if (this.typeNameMap == null) {
            return typeName;
        }
        String shortName = this.typeNameMap.get(typeName);
        return shortName == null ? typeName : shortName;
    }

    public static String objectToJson(Object item, Map<String, Object> optionalArgs) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            JsonWriter writer = new JsonWriter(stream, optionalArgs);
            writer.write(item);
            writer.close();
            return new String(stream.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            throw new JsonIoException("Unable to convert object to JSON", e);
        }
    }

    public static String formatJson(String json) {
        Map map = JsonReader.jsonToMaps(json);
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PRETTY_PRINT, true);
        return JsonWriter.objectToJson(map, args);
    }

    public JsonWriter(OutputStream out) {
        this(out, new HashMap<String, Object>());
    }

    public JsonWriter(OutputStream out, Map<String, Object> optionalArgs) {
        Map args = JsonWriter.getArgs();
        args.clear();
        args.putAll(optionalArgs);
        args.put("JSON_WRITER", this);
        this.typeNameMap = (Map)JsonWriter.getArg(TYPE_NAME_MAP);
        this.shortMetaKeys = Boolean.TRUE.equals(args.get(SHORT_META_KEYS));
        if (optionalArgs.containsKey(FIELD_SPECIFIERS)) {
            Map specifiers = (Map)args.get(FIELD_SPECIFIERS);
            HashMap copy = new HashMap();
            for (Map.Entry entry : specifiers.entrySet()) {
                Class c = (Class)entry.getKey();
                List fields = (List)entry.getValue();
                ArrayList<Field> newList = new ArrayList<Field>(fields.size());
                Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(c);
                for (String field : fields) {
                    Field f = classFields.get(field);
                    if (f == null) {
                        throw new JsonIoException("Unable to locate field: " + field + " on class: " + c.getName() + ". Make sure the fields in the FIELD_SPECIFIERS map existing on the associated class.");
                    }
                    newList.add(f);
                }
                copy.put(c, newList);
            }
            args.put(FIELD_SPECIFIERS, copy);
        } else {
            args.put(FIELD_SPECIFIERS, new HashMap());
        }
        try {
            this.out = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new JsonIoException("UTF-8 not supported on your JVM.  Unable to convert object to JSON.", e);
        }
    }

    public static boolean isPublicEnumsOnly() {
        return JsonWriter.isTrue(JsonWriter.getArg(ENUM_PUBLIC_ONLY));
    }

    public static boolean isPrettyPrint() {
        return JsonWriter.isTrue(JsonWriter.getArg(PRETTY_PRINT));
    }

    public static boolean getWriteLongsAsStrings() {
        return JsonWriter.isTrue(JsonWriter.getArg(WRITE_LONGS_AS_STRINGS));
    }

    private static boolean isTrue(Object setting) {
        if (setting instanceof Boolean) {
            return Boolean.TRUE.equals(setting);
        }
        if (setting instanceof String) {
            return "true".equalsIgnoreCase((String)setting);
        }
        if (setting instanceof Number) {
            return ((Number)setting).intValue() != 0;
        }
        return false;
    }

    protected void tabIn() throws IOException {
        this.tab(this.out, 1);
    }

    protected void newLine() throws IOException {
        this.tab(this.out, 0);
    }

    protected void tabOut() throws IOException {
        this.tab(this.out, -1);
    }

    private void tab(Writer output, int delta) throws IOException {
        if (!JsonWriter.isPrettyPrint()) {
            return;
        }
        output.write(newLine);
        this.depth += delta;
        int i = 0;
        while (i < this.depth) {
            output.write("  ");
            ++i;
        }
    }

    public boolean writeIfMatching(Object o, boolean showType, Writer output) {
        Class<?> c = o.getClass();
        if (notCustom.contains(c)) {
            return false;
        }
        try {
            return this.writeCustom(c, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object:", e);
        }
    }

    public boolean writeArrayElementIfMatching(Class arrayComponentClass, Object o, boolean showType, Writer output) {
        if (!o.getClass().isAssignableFrom(arrayComponentClass) || notCustom.contains(o.getClass())) {
            return false;
        }
        try {
            return this.writeCustom(arrayComponentClass, o, showType, output);
        }
        catch (IOException e) {
            throw new JsonIoException("Unable to write custom formatted object as array element:", e);
        }
    }

    protected boolean writeCustom(Class arrayComponentClass, Object o, boolean showType, Writer output) throws IOException {
        JsonClassWriter writer;
        JsonClassWriterBase closestWriter = JsonWriter.getCustomWriter(arrayComponentClass);
        if (closestWriter == null) {
            return false;
        }
        if (this.writeOptionalReference(o)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(o);
        if (closestWriter instanceof JsonClassWriter && (writer = (JsonClassWriter)closestWriter).hasPrimitiveForm() && (!referenced && !showType || closestWriter instanceof Writers.JsonStringWriter)) {
            writer.writePrimitiveForm(o, output);
            return true;
        }
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(o));
            if (showType) {
                output.write(44);
                this.newLine();
            }
        }
        if (showType) {
            this.writeType(o, output);
        }
        if (referenced || showType) {
            output.write(44);
            this.newLine();
        }
        if (closestWriter instanceof JsonClassWriterEx) {
            ((JsonClassWriterEx)closestWriter).write(o, showType || referenced, output, JsonWriter.getArgs());
        } else {
            ((JsonClassWriter)closestWriter).write(o, showType || referenced, output);
        }
        this.tabOut();
        output.write(125);
        return true;
    }

    private static JsonClassWriterBase getCustomWriter(Class c) {
        JsonClassWriterBase writerRef;
        JsonClassWriterBase writer = (JsonClassWriterBase)writerCache.get(c);
        if (writer == null && (writerRef = writerCache.putIfAbsent(c, writer = JsonWriter.forceGetCustomWriter(c))) != null) {
            writer = writerRef;
        }
        return writer == nullWriter ? null : writer;
    }

    private static JsonClassWriterBase forceGetCustomWriter(Class c) {
        JsonClassWriterBase closestWriter = nullWriter;
        int minDistance = Integer.MAX_VALUE;
        for (Map.Entry entry : writers.entrySet()) {
            Class clz = (Class)entry.getKey();
            if (clz == c) {
                return (JsonClassWriterBase)entry.getValue();
            }
            int distance = MetaUtils.getDistance(clz, c);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closestWriter = (JsonClassWriterBase)entry.getValue();
        }
        return closestWriter;
    }

    public static void addWriter(Class c, JsonClassWriterBase writer) {
        for (Map.Entry entry : writers.entrySet()) {
            Class clz = (Class)entry.getKey();
            if (clz != c) continue;
            entry.setValue(writer);
            return;
        }
        writers.put(c, writer);
    }

    public static void addNotCustomWriter(Class c) {
        notCustom.add(c);
    }

    public void write(Object obj) {
        this.traceReferences(obj);
        this.objVisited.clear();
        try {
            this.writeImpl(obj, true);
        }
        catch (IOException e) {
            throw new JsonIoException("Error writing object to JSON:", e);
        }
        this.flush();
        this.objVisited.clear();
        this.objsReferenced.clear();
        JsonWriter.getArgs().clear();
        _args.remove();
    }

    protected void traceReferences(Object root) {
        if (root == null) {
            return;
        }
        Map fieldSpecifiers = (Map)JsonWriter.getArg(FIELD_SPECIFIERS);
        ArrayDeque<Object> stack = new ArrayDeque<Object>();
        stack.addFirst(root);
        Map<Object, Long> visited = this.objVisited;
        Map<Object, Long> referenced = this.objsReferenced;
        while (!stack.isEmpty()) {
            Class<?> clazz;
            Object obj = stack.removeFirst();
            if (!MetaUtils.isLogicalPrimitive(obj.getClass())) {
                Long id = visited.get(obj);
                if (id != null) {
                    if (id != ZERO) continue;
                    id = this.identity++;
                    visited.put(obj, id);
                    referenced.put(obj, id);
                    continue;
                }
                visited.put(obj, ZERO);
            }
            if ((clazz = obj.getClass()).isArray()) {
                if (MetaUtils.isLogicalPrimitive(clazz.getComponentType())) continue;
                int len = Array.getLength(obj);
                int i = 0;
                while (i < len) {
                    Object o = Array.get(obj, i);
                    if (o != null) {
                        stack.addFirst(o);
                    }
                    ++i;
                }
                continue;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                Map map = (Map)obj;
                for (Map.Entry item : map.entrySet()) {
                    Map.Entry entry = item;
                    if (entry.getValue() != null) {
                        stack.addFirst(entry.getValue());
                    }
                    if (entry.getKey() == null) continue;
                    stack.addFirst(entry.getKey());
                }
                continue;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                for (Object item : (Collection)obj) {
                    if (item == null) continue;
                    stack.addFirst(item);
                }
                continue;
            }
            if (JsonWriter.getCustomWriter(obj.getClass()) != null) continue;
            this.traceFields(stack, obj, fieldSpecifiers);
        }
    }

    protected void traceFields(Deque<Object> stack, Object obj, Map<Class, List<Field>> fieldSpecifiers) {
        Collection<Field> fields = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        if (fields == null) {
            fields = MetaUtils.getDeepDeclaredFields(obj.getClass()).values();
        }
        for (Field field : fields) {
            try {
                Object o = field.get(obj);
                if (o == null || MetaUtils.isLogicalPrimitive(o.getClass())) continue;
                stack.addFirst(o);
            }
            catch (Exception exception) {}
        }
    }

    private static List<Field> getFieldsUsingSpecifier(Class classBeingWritten, Map<Class, List<Field>> fieldSpecifiers) {
        Iterator<Map.Entry<Class, List<Field>>> i = fieldSpecifiers.entrySet().iterator();
        int minDistance = Integer.MAX_VALUE;
        List<Field> fields = null;
        while (i.hasNext()) {
            Map.Entry<Class, List<Field>> entry = i.next();
            Class c = entry.getKey();
            if (c == classBeingWritten) {
                return entry.getValue();
            }
            int distance = MetaUtils.getDistance(c, classBeingWritten);
            if (distance >= minDistance) continue;
            minDistance = distance;
            fields = entry.getValue();
        }
        return fields;
    }

    private boolean writeOptionalReference(Object obj) throws IOException {
        if (obj != null && MetaUtils.isLogicalPrimitive(obj.getClass())) {
            return false;
        }
        Writer output = this.out;
        if (this.objVisited.containsKey(obj)) {
            String id = this.getId(obj);
            if (id == null) {
                return false;
            }
            output.write(this.shortMetaKeys ? "{\"@r\":" : "{\"@ref\":");
            output.write(id);
            output.write(125);
            return true;
        }
        this.objVisited.put(obj, null);
        return false;
    }

    public void writeImpl(Object obj, boolean showType) throws IOException {
        if (obj == null) {
            this.out.write("null");
            return;
        }
        if (obj.getClass().isArray()) {
            this.writeArray(obj, showType);
        } else if (obj instanceof Collection) {
            this.writeCollection((Collection)obj, showType);
        } else if (obj instanceof JsonObject) {
            JsonObject jObj = (JsonObject)obj;
            if (jObj.isArray()) {
                this.writeJsonObjectArray(jObj, showType);
            } else if (jObj.isCollection()) {
                this.writeJsonObjectCollection(jObj, showType);
            } else if (jObj.isMap()) {
                if (!this.writeJsonObjectMapWithStringKeys(jObj, showType)) {
                    this.writeJsonObjectMap(jObj, showType);
                }
            } else {
                this.writeJsonObjectObject(jObj, showType);
            }
        } else if (obj instanceof Map) {
            if (!this.writeMapWithStringKeys((Map)obj, showType)) {
                this.writeMap((Map)obj, showType);
            }
        } else {
            this.writeObject(obj, showType);
        }
    }

    private void writeId(String id) throws IOException {
        this.out.write(this.shortMetaKeys ? "\"@i\":" : "\"@id\":");
        this.out.write(id == null ? "0" : id);
    }

    private void writeType(Object obj, Writer output) throws IOException {
        output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
        Class<?> c = obj.getClass();
        String typeName = c.getName();
        String shortName = this.getSubstituteTypeNameIfExists(typeName);
        if (shortName != null) {
            output.write(shortName);
            output.write(34);
            return;
        }
        switch (c.getName()) {
            case "java.lang.Boolean": {
                output.write("boolean");
                break;
            }
            case "java.lang.Byte": {
                output.write("byte");
                break;
            }
            case "java.lang.Character": {
                output.write("char");
                break;
            }
            case "java.lang.Class": {
                output.write("class");
                break;
            }
            case "java.lang.Double": {
                output.write("double");
                break;
            }
            case "java.lang.Float": {
                output.write("float");
                break;
            }
            case "java.lang.Integer": {
                output.write("int");
                break;
            }
            case "java.lang.Long": {
                output.write("long");
                break;
            }
            case "java.lang.Short": {
                output.write("short");
                break;
            }
            case "java.lang.String": {
                output.write("string");
                break;
            }
            case "java.util.Date": {
                output.write("date");
                break;
            }
            default: {
                output.write(c.getName());
            }
        }
        output.write(34);
    }

    private void writePrimitive(Object obj, boolean showType) throws IOException {
        if (obj instanceof Character) {
            JsonWriter.writeJsonUtf8String(String.valueOf(obj), this.out);
        } else if (obj instanceof Long && JsonWriter.getWriteLongsAsStrings()) {
            if (showType) {
                this.out.write(this.shortMetaKeys ? "{\"@t\":\"" : "{\"@type\":\"");
                this.out.write(this.getSubstituteTypeName("long"));
                this.out.write("\",\"value\":\"");
                this.out.write(obj.toString());
                this.out.write("\"}");
            } else {
                this.out.write(34);
                this.out.write(obj.toString());
                this.out.write(34);
            }
        } else {
            this.out.write(obj.toString());
        }
    }

    private void writeArray(Object array, boolean showType) throws IOException {
        if (this.writeOptionalReference(array)) {
            return;
        }
        Class<?> arrayType = array.getClass();
        int len = Array.getLength(array);
        boolean referenced = this.objsReferenced.containsKey(array);
        boolean typeWritten = showType && !arrayType.equals(Object[].class);
        Writer output = this.out;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(this.getId(array));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            this.writeType(array, output);
            output.write(44);
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write(125);
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@i\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        int lenMinus1 = len - 1;
        if (byte[].class == arrayType) {
            this.writeByteArray((byte[])array, lenMinus1);
        } else if (char[].class == arrayType) {
            JsonWriter.writeJsonUtf8String(new String((char[])array), output);
        } else if (short[].class == arrayType) {
            this.writeShortArray((short[])array, lenMinus1);
        } else if (int[].class == arrayType) {
            this.writeIntArray((int[])array, lenMinus1);
        } else if (long[].class == arrayType) {
            this.writeLongArray((long[])array, lenMinus1);
        } else if (float[].class == arrayType) {
            this.writeFloatArray((float[])array, lenMinus1);
        } else if (double[].class == arrayType) {
            this.writeDoubleArray((double[])array, lenMinus1);
        } else if (boolean[].class == arrayType) {
            this.writeBooleanArray((boolean[])array, lenMinus1);
        } else {
            Class<?> componentClass = array.getClass().getComponentType();
            boolean isPrimitiveArray = MetaUtils.isPrimitive(componentClass);
            boolean isObjectArray = Object[].class == arrayType;
            int i = 0;
            while (i < len) {
                Object value = Array.get(array, i);
                if (value == null) {
                    output.write("null");
                } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                    if (isPrimitiveArray || value instanceof Boolean || value instanceof Long || value instanceof Double) {
                        this.writePrimitive(value, value.getClass() != componentClass);
                    } else if (isObjectArray) {
                        if (!this.writeIfMatching(value, true, output)) {
                            this.writeImpl(value, true);
                        }
                    } else {
                        boolean forceType = value.getClass() != componentClass;
                        this.writeImpl(value, forceType || JsonWriter.alwaysShowType());
                    }
                }
                if (i != lenMinus1) {
                    output.write(44);
                    this.newLine();
                }
                ++i;
            }
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private static boolean alwaysShowType() {
        return Boolean.TRUE.equals(JsonWriter.getArgs().containsKey(TYPE));
    }

    private void writeBooleanArray(boolean[] booleans, int lenMinus1) throws IOException {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(booleans[i] ? "true," : "false,");
            ++i;
        }
        output.write(Boolean.toString(booleans[lenMinus1]));
    }

    private void writeDoubleArray(double[] doubles, int lenMinus1) throws IOException {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Double.toString(doubles[i]));
            output.write(44);
            ++i;
        }
        output.write(Double.toString(doubles[lenMinus1]));
    }

    private void writeFloatArray(float[] floats, int lenMinus1) throws IOException {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Float.toString(floats[i]));
            output.write(44);
            ++i;
        }
        output.write(Float.toString(floats[lenMinus1]));
    }

    private void writeLongArray(long[] longs, int lenMinus1) throws IOException {
        Writer output = this.out;
        if (JsonWriter.getWriteLongsAsStrings()) {
            int i = 0;
            while (i < lenMinus1) {
                output.write(34);
                output.write(Long.toString(longs[i]));
                output.write(34);
                output.write(44);
                ++i;
            }
            output.write(34);
            output.write(Long.toString(longs[lenMinus1]));
            output.write(34);
        } else {
            int i = 0;
            while (i < lenMinus1) {
                output.write(Long.toString(longs[i]));
                output.write(44);
                ++i;
            }
            output.write(Long.toString(longs[lenMinus1]));
        }
    }

    private void writeIntArray(int[] ints, int lenMinus1) throws IOException {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Integer.toString(ints[i]));
            output.write(44);
            ++i;
        }
        output.write(Integer.toString(ints[lenMinus1]));
    }

    private void writeShortArray(short[] shorts, int lenMinus1) throws IOException {
        Writer output = this.out;
        int i = 0;
        while (i < lenMinus1) {
            output.write(Integer.toString(shorts[i]));
            output.write(44);
            ++i;
        }
        output.write(Integer.toString(shorts[lenMinus1]));
    }

    private void writeByteArray(byte[] bytes, int lenMinus1) throws IOException {
        Writer output = this.out;
        Object[] byteStrs = byteStrings;
        int i = 0;
        while (i < lenMinus1) {
            output.write((char[])byteStrs[bytes[i] + 128]);
            output.write(44);
            ++i;
        }
        output.write((char[])byteStrs[bytes[lenMinus1] + 128]);
    }

    private void writeCollection(Collection col, boolean showType) throws IOException {
        if (this.writeOptionalReference(col)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(col);
        boolean isEmpty = col.isEmpty();
        if (referenced || showType) {
            output.write(123);
            this.tabIn();
        } else if (isEmpty) {
            output.write(91);
        }
        this.writeIdAndTypeIfNeeded(col, showType, referenced);
        if (isEmpty) {
            if (referenced || showType) {
                this.tabOut();
                output.write(125);
            } else {
                output.write(93);
            }
            return;
        }
        this.beginCollection(showType, referenced);
        Iterator i = col.iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(93);
        if (showType || referenced) {
            this.tabOut();
            output.write("}");
        }
    }

    private void writeIdAndTypeIfNeeded(Object col, boolean showType, boolean referenced) throws IOException {
        if (referenced) {
            this.writeId(this.getId(col));
        }
        if (showType) {
            if (referenced) {
                this.out.write(44);
                this.newLine();
            }
            this.writeType(col, this.out);
        }
    }

    private void beginCollection(boolean showType, boolean referenced) throws IOException {
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
            this.out.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            this.out.write(91);
        }
        this.tabIn();
    }

    private void writeJsonObjectArray(JsonObject jObj, boolean showType) throws IOException {
        boolean typeWritten;
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        int len = jObj.getLength();
        String type = jObj.type;
        Class arrayClass = type == null || Object[].class.getName().equals(type) ? Object[].class : MetaUtils.classForName(type);
        Writer output = this.out;
        boolean isObjectArray = Object[].class == arrayClass;
        Class<?> componentClass = arrayClass.getComponentType();
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        boolean bl = typeWritten = showType && !isObjectArray;
        if (typeWritten || referenced) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(Long.toString(jObj.id));
            output.write(44);
            this.newLine();
        }
        if (typeWritten) {
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(arrayClass.getName()));
            output.write("\",");
            this.newLine();
        }
        if (len == 0) {
            if (typeWritten || referenced) {
                output.write(this.shortMetaKeys ? "\"@e\":[]" : "\"@items\":[]");
                this.tabOut();
                output.write("}");
            } else {
                output.write("[]");
            }
            return;
        }
        if (typeWritten || referenced) {
            output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        } else {
            output.write(91);
        }
        this.tabIn();
        Object[] items = (Object[])jObj.get("@items");
        int lenMinus1 = len - 1;
        int i = 0;
        while (i < len) {
            Object value = items[i];
            if (value == null) {
                output.write("null");
            } else if (Character.class == componentClass || Character.TYPE == componentClass) {
                JsonWriter.writeJsonUtf8String((String)value, output);
            } else if (value instanceof Boolean || value instanceof Long || value instanceof Double) {
                this.writePrimitive(value, value.getClass() != componentClass);
            } else if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, output);
            } else if (isObjectArray) {
                if (!this.writeIfMatching(value, true, output)) {
                    this.writeImpl(value, true);
                }
            } else if (!this.writeArrayElementIfMatching(componentClass, value, false, output)) {
                boolean forceType = value.getClass() != componentClass;
                this.writeImpl(value, forceType || JsonWriter.alwaysShowType());
            }
            if (i != lenMinus1) {
                output.write(44);
                this.newLine();
            }
            ++i;
        }
        this.tabOut();
        output.write(93);
        if (typeWritten || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectCollection(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        String type = jObj.type;
        Class colClass = MetaUtils.classForName(type);
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        int len = jObj.getLength();
        if (referenced || showType || len == 0) {
            output.write(123);
            this.tabIn();
        }
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(colClass.getName()));
            output.write(34);
        }
        if (len == 0) {
            this.tabOut();
            output.write(125);
            return;
        }
        this.beginCollection(showType, referenced);
        Object[] items = (Object[])jObj.get("@items");
        int itemsLen = items.length;
        int itemsLenMinus1 = itemsLen - 1;
        int i = 0;
        while (i < itemsLen) {
            this.writeCollectionElement(items[i]);
            if (i != itemsLenMinus1) {
                output.write(44);
                this.newLine();
            }
            ++i;
        }
        this.tabOut();
        output.write("]");
        if (showType || referenced) {
            this.tabOut();
            output.write(125);
        }
    }

    private void writeJsonObjectMap(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            String type;
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            if ((type = jObj.getType()) != null) {
                Class mapClass = MetaUtils.classForName(type);
                output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
                output.write(this.getSubstituteTypeName(mapClass.getName()));
                output.write(34);
            } else {
                showType = false;
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        output.write(this.shortMetaKeys ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = jObj.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        i = jObj.values().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(93);
        this.tabOut();
        output.write(125);
    }

    private boolean writeJsonObjectMapWithStringKeys(JsonObject jObj, boolean showType) throws IOException {
        if (!JsonWriter.ensureJsonPrimitiveKeys(jObj)) {
            return false;
        }
        if (this.writeOptionalReference(jObj)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        Writer output = this.out;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.getId()));
        }
        if (showType) {
            String type;
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            if ((type = jObj.getType()) != null) {
                Class mapClass = MetaUtils.classForName(type);
                output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
                output.write(this.getSubstituteTypeName(mapClass.getName()));
                output.write(34);
            } else {
                showType = false;
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return true;
        }
        if (showType) {
            output.write(44);
            this.newLine();
        }
        return this.writeMapBody(jObj.entrySet().iterator());
    }

    private void writeJsonObjectObject(JsonObject jObj, boolean showType) throws IOException {
        if (this.writeOptionalReference(jObj)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(jObj) && jObj.hasId();
        showType = showType && jObj.type != null;
        Class type = null;
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(String.valueOf(jObj.id));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            output.write(this.shortMetaKeys ? "\"@t\":\"" : "\"@type\":\"");
            output.write(this.getSubstituteTypeName(jObj.type));
            output.write(34);
            try {
                type = MetaUtils.classForName(jObj.type);
            }
            catch (Exception exception) {
                type = null;
            }
        }
        if (jObj.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        Iterator i = jObj.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String fieldName = (String)entry.getKey();
            output.write(34);
            output.write(fieldName);
            output.write("\":");
            Object value = entry.getValue();
            if (value == null) {
                output.write("null");
            } else if (value instanceof BigDecimal || value instanceof BigInteger) {
                this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            } else if (value instanceof Number || value instanceof Boolean) {
                output.write(value.toString());
            } else if (value instanceof String) {
                JsonWriter.writeJsonUtf8String((String)value, output);
            } else if (value instanceof Character) {
                JsonWriter.writeJsonUtf8String(String.valueOf(value), output);
            } else {
                this.writeImpl(value, !JsonWriter.doesValueTypeMatchFieldType(type, fieldName, value));
            }
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(125);
    }

    private static boolean doesValueTypeMatchFieldType(Class type, String fieldName, Object value) {
        if (type != null) {
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(type);
            Field field = classFields.get(fieldName);
            return field != null && value.getClass() == field.getType();
        }
        return false;
    }

    private void writeMap(Map map, boolean showType) throws IOException {
        if (this.writeOptionalReference(map)) {
            return;
        }
        Writer output = this.out;
        boolean referenced = this.objsReferenced.containsKey(map);
        output.write(123);
        this.tabIn();
        if (referenced) {
            this.writeId(this.getId(map));
        }
        if (showType) {
            if (referenced) {
                output.write(44);
                this.newLine();
            }
            this.writeType(map, output);
        }
        if (map.isEmpty()) {
            this.tabOut();
            output.write(125);
            return;
        }
        if (showType || referenced) {
            output.write(44);
            this.newLine();
        }
        output.write(this.shortMetaKeys ? "\"@k\":[" : "\"@keys\":[");
        this.tabIn();
        Iterator<Object> i = map.keySet().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write("],");
        this.newLine();
        output.write(this.shortMetaKeys ? "\"@e\":[" : "\"@items\":[");
        this.tabIn();
        i = map.values().iterator();
        while (i.hasNext()) {
            this.writeCollectionElement(i.next());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(93);
        this.tabOut();
        output.write(125);
    }

    private boolean writeMapWithStringKeys(Map map, boolean showType) throws IOException {
        if (!JsonWriter.ensureJsonPrimitiveKeys(map)) {
            return false;
        }
        if (this.writeOptionalReference(map)) {
            return true;
        }
        boolean referenced = this.objsReferenced.containsKey(map);
        this.out.write(123);
        this.tabIn();
        this.writeIdAndTypeIfNeeded(map, showType, referenced);
        if (map.isEmpty()) {
            this.tabOut();
            this.out.write(125);
            return true;
        }
        if (showType || referenced) {
            this.out.write(44);
            this.newLine();
        }
        return this.writeMapBody(map.entrySet().iterator());
    }

    private boolean writeMapBody(Iterator i) throws IOException {
        Writer output = this.out;
        while (i.hasNext()) {
            Map.Entry att2value = (Map.Entry)i.next();
            output.write("\"");
            output.write((String)att2value.getKey());
            output.write("\":");
            this.writeCollectionElement(att2value.getValue());
            if (!i.hasNext()) continue;
            output.write(44);
            this.newLine();
        }
        this.tabOut();
        output.write(125);
        return true;
    }

    public static boolean ensureJsonPrimitiveKeys(Map map) {
        for (Object o : map.keySet()) {
            if (o instanceof String) continue;
            return false;
        }
        return true;
    }

    private void writeCollectionElement(Object o) throws IOException {
        if (o == null) {
            this.out.write("null");
        } else if (o instanceof Boolean || o instanceof Double) {
            this.out.write(o.toString());
        } else if (o instanceof Long) {
            this.writePrimitive(o, JsonWriter.getWriteLongsAsStrings());
        } else if (o instanceof String) {
            JsonWriter.writeJsonUtf8String((String)o, this.out);
        } else {
            this.writeImpl(o, true);
        }
    }

    private void writeObject(Object obj, boolean showType) throws IOException {
        boolean first;
        if (this.writeIfMatching(obj, showType, this.out)) {
            return;
        }
        if (this.writeOptionalReference(obj)) {
            return;
        }
        this.out.write(123);
        this.tabIn();
        boolean referenced = this.objsReferenced.containsKey(obj);
        if (referenced) {
            this.writeId(this.getId(obj));
        }
        if (referenced && showType) {
            this.out.write(44);
            this.newLine();
        }
        if (showType) {
            this.writeType(obj, this.out);
        }
        boolean bl = first = !showType;
        if (referenced && !showType) {
            first = false;
        }
        Map fieldSpecifiers = (Map)JsonWriter.getArg(FIELD_SPECIFIERS);
        List<Field> externallySpecifiedFields = JsonWriter.getFieldsUsingSpecifier(obj.getClass(), fieldSpecifiers);
        if (externallySpecifiedFields != null) {
            for (Field field : externallySpecifiedFields) {
                first = this.writeField(obj, first, field.getName(), field, true);
            }
        } else {
            Map<String, Field> classFields = MetaUtils.getDeepDeclaredFields(obj.getClass());
            for (Map.Entry<String, Field> entry : classFields.entrySet()) {
                String fieldName = entry.getKey();
                Field field = entry.getValue();
                first = this.writeField(obj, first, fieldName, field, false);
            }
        }
        this.tabOut();
        this.out.write(125);
    }

    private boolean writeField(Object obj, boolean first, String fieldName, Field field, boolean allowTransient) throws IOException {
        boolean forceType;
        Object o;
        if (!allowTransient && (field.getModifiers() & 0x80) != 0) {
            return first;
        }
        int modifiers = field.getModifiers();
        if (field.getDeclaringClass().isEnum() && !Modifier.isPublic(modifiers) && JsonWriter.isPublicEnumsOnly()) {
            return first;
        }
        if (!first) {
            this.out.write(44);
            this.newLine();
        }
        JsonWriter.writeJsonUtf8String(fieldName, this.out);
        this.out.write(58);
        try {
            o = field.get(obj);
        }
        catch (Exception exception) {
            o = null;
        }
        if (o == null) {
            this.out.write("null");
            return false;
        }
        Class<?> type = field.getType();
        boolean bl = forceType = o.getClass() != type;
        if (MetaUtils.isPrimitive(type)) {
            this.writePrimitive(o, false);
        } else if (!this.writeIfMatching(o, forceType, this.out)) {
            this.writeImpl(o, forceType || JsonWriter.alwaysShowType());
        }
        return false;
    }

    public static void writeJsonUtf8String(String s, Writer output) throws IOException {
        output.write(34);
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c < ' ') {
                switch (c) {
                    case '\b': {
                        output.write("\\b");
                        break;
                    }
                    case '\f': {
                        output.write("\\f");
                        break;
                    }
                    case '\n': {
                        output.write("\\n");
                        break;
                    }
                    case '\r': {
                        output.write("\\r");
                        break;
                    }
                    case '\t': {
                        output.write("\\t");
                        break;
                    }
                    default: {
                        String hex = Integer.toHexString(c);
                        output.write("\\u");
                        int pad = 4 - hex.length();
                        int k = 0;
                        while (k < pad) {
                            output.write(48);
                            ++k;
                        }
                        output.write(hex);
                        break;
                    }
                }
            } else if (c == '\\' || c == '\"') {
                output.write(92);
                output.write(c);
            } else {
                output.write(c);
            }
            ++i;
        }
        output.write(34);
    }

    @Override
    public void flush() {
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (Exception exception) {}
    }

    private String getId(Object o) {
        long id;
        if (o instanceof JsonObject && (id = ((JsonObject)o).id) != -1L) {
            return String.valueOf(id);
        }
        Long id2 = this.objsReferenced.get(o);
        return id2 == null ? null : Long.toString(id2);
    }

    public static interface JsonClassWriter
    extends JsonClassWriterBase {
        public void write(Object var1, boolean var2, Writer var3) throws IOException;

        public boolean hasPrimitiveForm();

        public void writePrimitiveForm(Object var1, Writer var2) throws IOException;
    }

    public static interface JsonClassWriterBase {
    }

    public static interface JsonClassWriterEx
    extends JsonClassWriterBase {
        public static final String JSON_WRITER = "JSON_WRITER";

        public void write(Object var1, boolean var2, Writer var3, Map<String, Object> var4) throws IOException;

        public static class Support {
            public static JsonWriter getWriter(Map<String, Object> args) {
                return (JsonWriter)args.get(JsonClassWriterEx.JSON_WRITER);
            }
        }
    }

    static class NullClass
    implements JsonClassWriterBase {
        NullClass() {
        }
    }
}

