/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.geom.Dimension;
import com.cedarsoftware.util.geom.Insets;
import com.cedarsoftware.util.geom.Point;
import com.cedarsoftware.util.geom.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class RectangleConversions {
    private RectangleConversions() {
    }

    static String toString(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return "(" + rectangle.getX() + "," + rectangle.getY() + "," + rectangle.getWidth() + "," + rectangle.getHeight() + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("x", rectangle.getX());
        target.put("y", rectangle.getY());
        target.put("width", rectangle.getWidth());
        target.put("height", rectangle.getHeight());
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new int[]{rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight()};
    }

    static Long toLong(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return (long)rectangle.getWidth() * (long)rectangle.getHeight();
    }

    static Integer toInteger(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return rectangle.getWidth() * rectangle.getHeight();
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return BigInteger.valueOf((long)rectangle.getWidth() * (long)rectangle.getHeight());
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from Rectangle to BigDecimal - no meaningful conversion exists.");
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return rectangle.getX() != 0 || rectangle.getY() != 0 || rectangle.getWidth() != 0 || rectangle.getHeight() != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(RectangleConversions.toBoolean(from, converter));
    }

    static Point toPoint(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Point(rectangle.getX(), rectangle.getY());
    }

    static Dimension toDimension(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Dimension(rectangle.getWidth(), rectangle.getHeight());
    }

    static Insets toInsets(Object from, Converter converter) {
        Rectangle rectangle = (Rectangle)from;
        return new Insets(rectangle.getY(), rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getX() + rectangle.getWidth());
    }
}

