/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.StringUtilities;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.function.IntSupplier;

public class DataGeneratorInputStream
extends InputStream {
    private final long size;
    private long bytesRead;
    private final IntSupplier generator;

    public DataGeneratorInputStream(long size, IntSupplier generator) {
        if (size < 0L) {
            throw new IllegalArgumentException("Size cannot be negative: " + size);
        }
        if (generator == null) {
            throw new NullPointerException("Generator cannot be null");
        }
        this.size = size;
        this.bytesRead = 0L;
        this.generator = generator;
    }

    public static DataGeneratorInputStream withRandomBytes(long size) {
        return DataGeneratorInputStream.withRandomBytes(size, 12345L, true);
    }

    public static DataGeneratorInputStream withRandomBytes(long size, long seed) {
        return DataGeneratorInputStream.withRandomBytes(size, seed, true);
    }

    public static DataGeneratorInputStream withRandomBytes(long size, long seed, boolean includeZero) {
        Random random = new Random(seed);
        if (includeZero) {
            return new DataGeneratorInputStream(size, () -> random.nextInt(256));
        }
        return new DataGeneratorInputStream(size, () -> 1 + random.nextInt(255));
    }

    public static DataGeneratorInputStream withRepeatingPattern(long size, String pattern) {
        if (pattern == null) {
            throw new NullPointerException("Pattern cannot be null");
        }
        byte[] bytes = pattern.getBytes(StandardCharsets.UTF_8);
        return DataGeneratorInputStream.withRepeatingPattern(size, bytes);
    }

    public static DataGeneratorInputStream withRepeatingPattern(long size, final byte[] pattern) {
        if (pattern == null) {
            throw new NullPointerException("Pattern cannot be null");
        }
        if (pattern.length == 0) {
            throw new IllegalArgumentException("Pattern cannot be empty");
        }
        return new DataGeneratorInputStream(size, new IntSupplier(){
            private int index = 0;

            @Override
            public int getAsInt() {
                int b = pattern[this.index] & 0xFF;
                this.index = (this.index + 1) % pattern.length;
                return b;
            }
        });
    }

    public static DataGeneratorInputStream withConstantByte(long size, int constantByte) {
        int byteValue = constantByte & 0xFF;
        return new DataGeneratorInputStream(size, () -> byteValue);
    }

    public static DataGeneratorInputStream withSequentialBytes(long size, int startByte, int endByte) {
        final int start = startByte & 0xFF;
        final int end = endByte & 0xFF;
        return new DataGeneratorInputStream(size, new IntSupplier(){
            private int current;
            private final boolean countUp;
            {
                this.current = start;
                this.countUp = start <= end;
            }

            @Override
            public int getAsInt() {
                int result = this.current;
                this.current = this.countUp ? (this.current == end ? start : ++this.current) : (this.current == end ? start : --this.current);
                return result;
            }
        });
    }

    public static DataGeneratorInputStream withRandomStrings(long size, final Random random, final int minWordLen, final int maxWordLen, final int separator) {
        if (random == null) {
            throw new NullPointerException("Random cannot be null");
        }
        return new DataGeneratorInputStream(size, new IntSupplier(){
            private byte[] currentWord = null;
            private int wordIndex = 0;
            private boolean needsSeparator = false;

            @Override
            public int getAsInt() {
                if (this.needsSeparator) {
                    this.needsSeparator = false;
                    this.currentWord = null;
                    this.wordIndex = 0;
                    return separator & 0xFF;
                }
                if (this.currentWord == null || this.wordIndex >= this.currentWord.length) {
                    String word = StringUtilities.getRandomString(random, minWordLen, maxWordLen);
                    this.currentWord = word.getBytes(StandardCharsets.UTF_8);
                    this.wordIndex = 0;
                    this.needsSeparator = false;
                }
                int result = this.currentWord[this.wordIndex++] & 0xFF;
                if (this.wordIndex >= this.currentWord.length) {
                    this.needsSeparator = true;
                }
                return result;
            }
        });
    }

    public static DataGeneratorInputStream withGenerator(long size, IntSupplier generator) {
        return new DataGeneratorInputStream(size, generator);
    }

    @Override
    public int read() {
        if (this.bytesRead >= this.size) {
            return -1;
        }
        ++this.bytesRead;
        return this.generator.getAsInt();
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Buffer cannot be null");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("Invalid offset or length");
        }
        if (len == 0) {
            return 0;
        }
        if (this.bytesRead >= this.size) {
            return -1;
        }
        long remaining = this.size - this.bytesRead;
        int bytesToRead = (int)Math.min((long)len, remaining);
        for (int i = 0; i < bytesToRead; ++i) {
            b[off + i] = (byte)this.generator.getAsInt();
        }
        this.bytesRead += (long)bytesToRead;
        return bytesToRead;
    }

    @Override
    public int available() {
        long remaining = this.size - this.bytesRead;
        return (int)Math.min(remaining, Integer.MAX_VALUE);
    }

    @Override
    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        long remaining = this.size - this.bytesRead;
        long bytesToSkip = Math.min(n, remaining);
        for (long i = 0L; i < bytesToSkip; ++i) {
            this.generator.getAsInt();
        }
        this.bytesRead += bytesToSkip;
        return bytesToSkip;
    }
}

