/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.CollectionUtilities;
import com.cedarsoftware.util.convert.CollectionHandling;
import com.cedarsoftware.util.convert.CollectionsWrappers;
import java.lang.reflect.Array;
import java.util.Collection;

public final class CollectionConversions {
    private CollectionConversions() {
    }

    public static <T extends Collection<?>> T arrayToCollection(Object array, Class<T> targetType) {
        int length = Array.getLength(array);
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<?> collection = CollectionHandling.createCollection(array, targetType);
        if (CollectionConversions.isEmptyCollection(targetType)) {
            return (T)collection;
        }
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            if (element != null && element.getClass().isArray()) {
                element = CollectionConversions.arrayToCollection(element, targetType);
            }
            collection.add(element);
        }
        if (targetType.isAssignableFrom(collection.getClass())) {
            return (T)collection;
        }
        if (requiresUnmodifiable) {
            return (T)CollectionUtilities.getUnmodifiableCollection(collection);
        }
        if (requiresSynchronized) {
            return (T)CollectionUtilities.getSynchronizedCollection(collection);
        }
        return (T)collection;
    }

    public static Object collectionToCollection(Collection<?> source, Class<?> targetType) {
        boolean requiresUnmodifiable = CollectionUtilities.isUnmodifiable(targetType);
        boolean requiresSynchronized = CollectionUtilities.isSynchronized(targetType);
        Collection<?> targetCollection = CollectionHandling.createCollection(source, targetType);
        if (CollectionConversions.isEmptyCollection(targetType)) {
            return targetCollection;
        }
        for (Object element : source) {
            if (element instanceof Collection) {
                element = CollectionConversions.collectionToCollection((Collection)element, targetType);
            }
            targetCollection.add(element);
        }
        if (targetType.isAssignableFrom(targetCollection.getClass())) {
            return targetCollection;
        }
        if (requiresUnmodifiable) {
            return CollectionUtilities.getUnmodifiableCollection(targetCollection);
        }
        if (requiresSynchronized) {
            return CollectionUtilities.getSynchronizedCollection(targetCollection);
        }
        return targetCollection;
    }

    private static boolean isEmptyCollection(Class<?> targetType) {
        return CollectionsWrappers.getEmptyCollectionClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptyListClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptySetClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptySortedSetClass().isAssignableFrom(targetType) || CollectionsWrappers.getEmptyNavigableSetClass().isAssignableFrom(targetType);
    }
}

