/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class PointConversions {
    private PointConversions() {
    }

    static String toString(Object from, Converter converter) {
        Point point = (Point)from;
        return "(" + point.x + "," + point.y + ")";
    }

    static Map<String, Object> toMap(Object from, Converter converter) {
        Point point = (Point)from;
        LinkedHashMap<String, Object> target = new LinkedHashMap<String, Object>();
        target.put("x", point.x);
        target.put("y", point.y);
        return target;
    }

    static int[] toIntArray(Object from, Converter converter) {
        Point point = (Point)from;
        return new int[]{point.x, point.y};
    }

    static Integer toInteger(Object from, Converter converter) {
        Point point = (Point)from;
        return point.x;
    }

    static Long toLong(Object from, Converter converter) {
        Point point = (Point)from;
        return point.x;
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Point point = (Point)from;
        return BigInteger.valueOf(point.x);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        throw new IllegalArgumentException("Unsupported conversion from Point to BigDecimal - no meaningful conversion exists.");
    }

    static Dimension toDimension(Object from, Converter converter) {
        Point point = (Point)from;
        return new Dimension(point.x, point.y);
    }

    static Boolean toBoolean(Object from, Converter converter) {
        Point point = (Point)from;
        return point.x != 0 || point.y != 0;
    }

    static AtomicBoolean toAtomicBoolean(Object from, Converter converter) {
        return new AtomicBoolean(PointConversions.toBoolean(from, converter));
    }

    static Rectangle toRectangle(Object from, Converter converter) {
        Point point = (Point)from;
        return new Rectangle(point.x, point.y, 0, 0);
    }

    static Insets toInsets(Object from, Converter converter) {
        Point point = (Point)from;
        return new Insets(point.x, point.y, 0, 0);
    }
}

