/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.CaseInsensitiveMap;
import com.cedarsoftware.util.CompactMap;
import com.cedarsoftware.util.Convention;
import com.cedarsoftware.util.ReflectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CompactSet<E>
implements Set<E> {
    private static final Object PRESENT = new Object();
    private final CompactMap<E, Object> map;

    public CompactSet() {
        CompactMap<Object, Object> defaultMap = ReflectionUtils.isJavaCompilerAvailable() ? CompactMap.builder().compactSize(this.compactSize()).caseSensitive(!this.isCaseInsensitive()).build() : CompactSet.createSimpleMap(!this.isCaseInsensitive(), this.compactSize(), "unordered");
        if (defaultMap.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = defaultMap;
    }

    protected CompactSet(CompactMap<E, Object> map) {
        if (map.compactSize() < 2) {
            throw new IllegalStateException("compactSize() must be >= 2");
        }
        this.map = map;
    }

    public CompactSet(Collection<? extends E> c) {
        this();
        this.addAll(c);
    }

    public boolean isDefaultCompactSet() {
        return this.map.isDefaultCompactMap();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.map.keySet().retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.map.keySet().removeAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.keySet().toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        return this.map.keySet().equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.keySet().hashCode();
    }

    public String toString() {
        return this.map.keySet().toString();
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    protected int compactSize() {
        return 50;
    }

    protected boolean isCaseInsensitive() {
        return false;
    }

    public Map<String, Object> getConfig() {
        Map<String, Object> mapConfig = this.map.getConfig();
        LinkedHashMap<String, Object> setConfig = new LinkedHashMap<String, Object>();
        setConfig.put("compactSize", mapConfig.get("compactSize"));
        setConfig.put("caseSensitive", mapConfig.get("caseSensitive"));
        setConfig.put("ordering", mapConfig.get("ordering"));
        return Collections.unmodifiableMap(setConfig);
    }

    public CompactSet<E> withConfig(Map<String, Object> config) {
        Convention.throwIfNull(config, "config cannot be null");
        Builder<E> builder = CompactSet.builder();
        Map<String, Object> currentConfig = this.map.getConfig();
        Integer configCompactSize = (Integer)config.get("compactSize");
        Integer currentCompactSize = (Integer)currentConfig.get("compactSize");
        int compactSizeToUse = configCompactSize != null ? configCompactSize : currentCompactSize;
        builder.compactSize(compactSizeToUse);
        Boolean configCaseSensitive = (Boolean)config.get("caseSensitive");
        Boolean currentCaseSensitive = (Boolean)currentConfig.get("caseSensitive");
        boolean caseSensitiveToUse = configCaseSensitive != null ? configCaseSensitive : currentCaseSensitive;
        builder.caseSensitive(caseSensitiveToUse);
        String configOrdering = (String)config.get("ordering");
        String currentOrdering = (String)currentConfig.get("ordering");
        String orderingToUse = configOrdering != null ? configOrdering : currentOrdering;
        this.applyOrdering(builder, orderingToUse);
        CompactSet<E> newSet = builder.build();
        newSet.addAll(this);
        return newSet;
    }

    private void applyOrdering(Builder<E> builder, String ordering) {
        if (ordering == null) {
            builder.noOrder();
            return;
        }
        switch (ordering) {
            case "sorted": {
                builder.sortedOrder();
                break;
            }
            case "reverse": {
                builder.reverseOrder();
                break;
            }
            case "insertion": {
                builder.insertionOrder();
                break;
            }
            default: {
                builder.noOrder();
            }
        }
    }

    static <E> CompactMap<E, Object> createSimpleMap(final boolean caseSensitive, final int size, final String ordering) {
        return new CompactMap<E, Object>(){

            @Override
            protected boolean isCaseInsensitive() {
                return !caseSensitive;
            }

            @Override
            protected int compactSize() {
                return size;
            }

            @Override
            protected String getOrdering() {
                return ordering;
            }

            @Override
            protected Map<E, Object> getNewMap() {
                int cap = size + 1;
                boolean ci = !caseSensitive;
                switch (ordering) {
                    case "insertion": {
                        return ci ? new CaseInsensitiveMap(Collections.emptyMap(), new LinkedHashMap(cap)) : new LinkedHashMap(cap);
                    }
                    case "sorted": 
                    case "reverse": {
                        CompactMap.CompactMapComparator comp = new CompactMap.CompactMapComparator(ci, "reverse".equals(ordering));
                        TreeMap tree = new TreeMap(comp);
                        return ci ? new CaseInsensitiveMap(Collections.emptyMap(), tree) : tree;
                    }
                }
                return ci ? new CaseInsensitiveMap(Collections.emptyMap(), new HashMap(cap)) : new HashMap(cap);
            }
        };
    }

    public static final class Builder<E> {
        private final CompactMap.Builder<E, Object> mapBuilder = CompactMap.builder();
        private boolean caseSensitive = true;
        private int compactSize = 50;
        private String ordering = "unordered";

        private Builder() {
        }

        public Builder<E> caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            this.mapBuilder.caseSensitive(caseSensitive);
            return this;
        }

        public Builder<E> compactSize(int size) {
            this.compactSize = size;
            this.mapBuilder.compactSize(size);
            return this;
        }

        public Builder<E> sortedOrder() {
            this.ordering = "sorted";
            this.mapBuilder.sortedOrder();
            return this;
        }

        public Builder<E> reverseOrder() {
            this.ordering = "reverse";
            this.mapBuilder.reverseOrder();
            return this;
        }

        public Builder<E> insertionOrder() {
            this.ordering = "insertion";
            this.mapBuilder.insertionOrder();
            return this;
        }

        public Builder<E> noOrder() {
            this.ordering = "unordered";
            this.mapBuilder.noOrder();
            return this;
        }

        public Builder<E> mapType(Class<? extends Map> mapType) {
            this.mapBuilder.mapType(mapType);
            return this;
        }

        public CompactSet<E> build() {
            CompactMap<E, Object> builtMap = ReflectionUtils.isJavaCompilerAvailable() ? this.mapBuilder.build() : CompactSet.createSimpleMap(this.caseSensitive, this.compactSize, this.ordering);
            return new CompactSet<E>(builtMap);
        }
    }
}

