/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public final class ArrayUtilities {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_ARRAY = new Character[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final int DEFAULT_MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final String DEFAULT_DANGEROUS_CLASS_PATTERNS = "java.lang.Runtime,java.lang.ProcessBuilder,java.lang.System,java.security.,javax.script.,sun.,com.sun.,java.lang.Class";

    private static void initializeSystemPropertyDefaults() {
        if (System.getProperty("arrayutilities.dangerous.class.patterns") == null) {
            System.setProperty("arrayutilities.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        }
        if (System.getProperty("arrayutilities.max.array.size") == null) {
            System.setProperty("arrayutilities.max.array.size", String.valueOf(0x7FFFFFF7));
        }
    }

    private static boolean isSecurityEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.security.enabled", "false"));
    }

    private static boolean isComponentTypeValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.component.type.validation.enabled", "false"));
    }

    private static boolean isDangerousClassValidationEnabled() {
        return Boolean.parseBoolean(System.getProperty("arrayutilities.dangerous.classes.validation.enabled", "false"));
    }

    private static long getMaxArraySize() {
        String maxSizeProp = System.getProperty("arrayutilities.max.array.size");
        if (maxSizeProp != null) {
            try {
                return Long.parseLong(maxSizeProp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ArrayUtilities.isSecurityEnabled() ? 0x7FFFFFF7L : Long.MAX_VALUE;
    }

    private static String[] getDangerousClassPatterns() {
        String patterns = System.getProperty("arrayutilities.dangerous.class.patterns", DEFAULT_DANGEROUS_CLASS_PATTERNS);
        return patterns.split(",");
    }

    private ArrayUtilities() {
    }

    private static void validateComponentType(Class<?> componentType) {
        String[] dangerousPatterns;
        if (componentType == null) {
            return;
        }
        if (!ArrayUtilities.isSecurityEnabled() || !ArrayUtilities.isComponentTypeValidationEnabled()) {
            return;
        }
        String className = componentType.getName();
        for (String pattern : dangerousPatterns = ArrayUtilities.getDangerousClassPatterns()) {
            if (!((pattern = pattern.trim()).endsWith(".") ? className.startsWith(pattern) : className.equals(pattern))) continue;
            throw new SecurityException("Array creation denied for security-sensitive class: " + className);
        }
    }

    static void validateArraySize(long size) {
        if (!ArrayUtilities.isSecurityEnabled()) {
            return;
        }
        if (size < 0L) {
            throw new SecurityException("Array size cannot be negative");
        }
        long maxSize = ArrayUtilities.getMaxArraySize();
        if (size > maxSize) {
            throw new SecurityException("Array size too large: " + size + " > " + maxSize);
        }
    }

    public static boolean isEmpty(Object array) {
        return array == null || Array.getLength(array) == 0;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtilities.isEmpty(array);
    }

    public static int size(Object array) {
        return array == null ? 0 : Array.getLength(array);
    }

    public static <T> T[] shallowCopy(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T[] nullToEmpty(Class<T> componentType, T[] array) {
        Objects.requireNonNull(componentType, "componentType is null");
        ArrayUtilities.validateComponentType(componentType);
        return array == null ? (Object[])Array.newInstance(componentType, 0) : array;
    }

    @SafeVarargs
    public static <T> T[] createArray(T ... elements) {
        if (elements == null) {
            return null;
        }
        return Arrays.copyOf(elements, elements.length);
    }

    public static <T> T[] addAll(T[] array1, T[] array2) {
        if (array1 == null) {
            return ArrayUtilities.shallowCopy(array2);
        }
        if (array2 == null) {
            return ArrayUtilities.shallowCopy(array1);
        }
        long combinedLength = (long)array1.length + (long)array2.length;
        ArrayUtilities.validateArraySize(combinedLength);
        Class<?> componentType = array1.getClass().getComponentType();
        ArrayUtilities.validateComponentType(componentType);
        Object[] newArray = (Object[])Array.newInstance(componentType, (int)combinedLength);
        System.arraycopy(array1, 0, newArray, 0, array1.length);
        System.arraycopy(array2, 0, newArray, array1.length, array2.length);
        return newArray;
    }

    public static <T> T[] removeItem(T[] array, int pos) {
        Objects.requireNonNull(array, "array cannot be null");
        int len = array.length;
        if (pos < 0 || pos >= len) {
            throw new ArrayIndexOutOfBoundsException("Invalid array index");
        }
        Class<?> componentType = array.getClass().getComponentType();
        ArrayUtilities.validateComponentType(componentType);
        Object[] dest = (Object[])Array.newInstance(componentType, len - 1);
        System.arraycopy(array, 0, dest, 0, pos);
        System.arraycopy(array, pos + 1, dest, pos, len - pos - 1);
        return dest;
    }

    public static <T> T[] addItem(Class<T> componentType, T[] array, T item) {
        Objects.requireNonNull(componentType, "componentType is null");
        ArrayUtilities.validateComponentType(componentType);
        if (array == null) {
            Object[] result = (Object[])Array.newInstance(componentType, 1);
            result[0] = item;
            return result;
        }
        long newLength = (long)array.length + 1L;
        ArrayUtilities.validateArraySize(newLength);
        T[] newArray = Arrays.copyOf(array, (int)newLength);
        newArray[array.length] = item;
        return newArray;
    }

    public static <T> int indexOf(T[] array, T item) {
        if (array == null) {
            return -1;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!Objects.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T item) {
        if (array == null) {
            return -1;
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (!Objects.equals(array[i], item)) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean contains(T[] array, T item) {
        return ArrayUtilities.indexOf(array, item) >= 0;
    }

    public static <T> T[] getArraySubset(T[] array, int start, int end) {
        return Arrays.copyOfRange(array, start, end);
    }

    public static <T> T[] toArray(Class<T> classToCastTo, Collection<?> c) {
        Objects.requireNonNull(classToCastTo, "classToCastTo is null");
        Objects.requireNonNull(c, "collection is null");
        ArrayUtilities.validateComponentType(classToCastTo);
        ArrayUtilities.validateArraySize(c.size());
        Object[] array = (Object[])Array.newInstance(classToCastTo, c.size());
        return c.toArray(array);
    }

    static {
        ArrayUtilities.initializeSystemPropertyDefaults();
    }
}

