/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.Convention;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrackingMap<K, V>
implements Map<K, V> {
    private final Map<K, V> internalMap;
    private final Set<Object> readKeys;

    public TrackingMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot construct a TrackingMap() with null");
        }
        this.internalMap = map;
        this.readKeys = new HashSet<Object>();
    }

    @Override
    public V get(Object key) {
        V value = this.internalMap.get(key);
        this.readKeys.add(key);
        return value;
    }

    @Override
    public V put(K key, V value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        boolean containsKey = this.internalMap.containsKey(key);
        this.readKeys.add(key);
        return containsKey;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public V remove(Object key) {
        this.readKeys.remove(key);
        return this.internalMap.remove(key);
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof Map && this.internalMap.equals(other);
    }

    @Override
    public int hashCode() {
        return this.internalMap.hashCode();
    }

    public String toString() {
        return this.internalMap.toString();
    }

    @Override
    public void clear() {
        this.readKeys.clear();
        this.internalMap.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Collection<V> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.internalMap.entrySet();
    }

    public void expungeUnused() {
        this.internalMap.keySet().retainAll(this.readKeys);
        this.readKeys.retainAll(this.internalMap.keySet());
    }

    public void informAdditionalUsage(Collection<K> additional) {
        this.readKeys.addAll(additional);
    }

    public void informAdditionalUsage(TrackingMap<K, V> additional) {
        this.readKeys.addAll(additional.readKeys);
    }

    public Set<Object> keysUsed() {
        return Collections.unmodifiableSet(this.readKeys);
    }

    public Map<K, V> getWrappedMap() {
        return this.internalMap;
    }

    public void replaceContents(Map<K, V> map) {
        Convention.throwIfNull(map, "Cannot replace contents with null");
        this.clear();
        this.putAll(map);
    }

    @Deprecated
    public void setWrappedMap(Map<K, V> map) {
        this.replaceContents(map);
    }
}

