/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.ArrayUtilities;

public final class ByteUtilities {
    private static final char[] _hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ByteUtilities() {
    }

    public static byte[] decode(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 2];
        int pos = 0;
        for (int i = 0; i < len; i += 2) {
            byte hi = (byte)Character.digit(s.charAt(i), 16);
            byte lo = (byte)Character.digit(s.charAt(i + 1), 16);
            bytes[pos++] = (byte)(hi * 16 + lo);
        }
        return bytes;
    }

    public static String encode(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = _hex[v >>> 4];
            hexChars[i * 2 + 1] = _hex[v & 0xF];
        }
        return new String(hexChars);
    }

    private static char convertDigit(int value) {
        return _hex[value & 0xF];
    }

    public static boolean isGzipped(byte[] bytes) {
        if (ArrayUtilities.size(bytes) < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

