/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

public class LRUCache<K, V>
implements Map<K, V> {
    private final Map<K, V> cache;
    private final transient ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Object NO_ENTRY = new Object();

    public LRUCache(final int capacity) {
        this.cache = new LinkedHashMap<K, V>(capacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > capacity;
            }
        };
    }

    @Override
    public boolean equals(Object obj) {
        return this.readOperation(() -> this.cache.equals(obj));
    }

    @Override
    public int hashCode() {
        return this.readOperation(this.cache::hashCode);
    }

    public String toString() {
        return this.readOperation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, toString(), ()Ljava/lang/String;)(this.cache));
    }

    @Override
    public int size() {
        return this.readOperation(this.cache::size);
    }

    @Override
    public boolean isEmpty() {
        return this.readOperation(this.cache::isEmpty);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.readOperation(() -> this.cache.containsKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.readOperation(() -> this.cache.containsValue(value));
    }

    @Override
    public V get(Object key) {
        return (V)this.readOperation(() -> this.cache.get(key));
    }

    @Override
    public V put(K key, V value) {
        return (V)this.writeOperation(() -> this.cache.put(key, value));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.writeOperation(() -> {
            this.cache.putAll(m);
            return null;
        });
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.writeOperation(() -> this.cache.putIfAbsent(key, value));
    }

    @Override
    public V remove(Object key) {
        return (V)this.writeOperation(() -> this.cache.remove(key));
    }

    @Override
    public void clear() {
        this.writeOperation(() -> {
            this.cache.clear();
            return null;
        });
    }

    @Override
    public Set<K> keySet() {
        return this.readOperation(() -> new Set<K>(){

            @Override
            public int size() {
                return (Integer)LRUCache.this.readOperation(LRUCache.this.cache::size);
            }

            @Override
            public boolean isEmpty() {
                return (Boolean)LRUCache.this.readOperation(LRUCache.this.cache::isEmpty);
            }

            @Override
            public boolean contains(Object o) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.containsKey(o));
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    private final Iterator<K> it;
                    private K current;
                    {
                        this.it = LRUCache.this.cache.keySet().iterator();
                        this.current = NO_ENTRY;
                    }

                    @Override
                    public boolean hasNext() {
                        return (Boolean)LRUCache.this.readOperation(this.it::hasNext);
                    }

                    @Override
                    public K next() {
                        return LRUCache.this.readOperation(() -> {
                            this.current = this.it.next();
                            return this.current;
                        });
                    }

                    @Override
                    public void remove() {
                        LRUCache.this.writeOperation(() -> {
                            if (this.current == NO_ENTRY) {
                                throw new IllegalStateException("Next not called or already removed");
                            }
                            this.it.remove();
                            this.current = NO_ENTRY;
                            return null;
                        });
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.keySet().toArray());
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.keySet().toArray(a));
            }

            @Override
            public boolean add(K k) {
                throw new UnsupportedOperationException("add() not supported on .keySet() of a Map");
            }

            @Override
            public boolean remove(Object o) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.remove(o) != null);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.keySet().containsAll(c));
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException("addAll() not supported on .keySet() of a Map");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.keySet().retainAll(c));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.keySet().removeAll(c));
            }

            @Override
            public void clear() {
                LRUCache.this.writeOperation(() -> {
                    LRUCache.this.cache.clear();
                    return null;
                });
            }
        });
    }

    @Override
    public Collection<V> values() {
        return this.readOperation(() -> new Collection<V>(){

            @Override
            public int size() {
                return (Integer)LRUCache.this.readOperation(LRUCache.this.cache::size);
            }

            @Override
            public boolean isEmpty() {
                return (Boolean)LRUCache.this.readOperation(LRUCache.this.cache::isEmpty);
            }

            @Override
            public boolean contains(Object o) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.containsValue(o));
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    private final Iterator<V> it;
                    private V current;
                    {
                        this.it = LRUCache.this.cache.values().iterator();
                        this.current = NO_ENTRY;
                    }

                    @Override
                    public boolean hasNext() {
                        return (Boolean)LRUCache.this.readOperation(this.it::hasNext);
                    }

                    @Override
                    public V next() {
                        return LRUCache.this.readOperation(() -> {
                            this.current = this.it.next();
                            return this.current;
                        });
                    }

                    @Override
                    public void remove() {
                        LRUCache.this.writeOperation(() -> {
                            if (this.current == NO_ENTRY) {
                                throw new IllegalStateException("Next not called or already removed");
                            }
                            this.it.remove();
                            this.current = NO_ENTRY;
                            return null;
                        });
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.values().toArray());
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.values().toArray(a));
            }

            @Override
            public boolean add(V value) {
                throw new UnsupportedOperationException("add() not supported on values() of a Map");
            }

            @Override
            public boolean remove(Object o) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.values().remove(o));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.values().containsAll(c));
            }

            @Override
            public boolean addAll(Collection<? extends V> c) {
                throw new UnsupportedOperationException("addAll() not supported on values() of a Map");
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.values().removeAll(c));
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.values().retainAll(c));
            }

            @Override
            public void clear() {
                LRUCache.this.writeOperation(() -> {
                    LRUCache.this.cache.clear();
                    return null;
                });
            }
        });
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.readOperation(() -> new Set<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return (Integer)LRUCache.this.readOperation(LRUCache.this.cache::size);
            }

            @Override
            public boolean isEmpty() {
                return (Boolean)LRUCache.this.readOperation(LRUCache.this.cache::isEmpty);
            }

            @Override
            public boolean contains(Object o) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.entrySet().contains(o));
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<Map.Entry<K, V>> it;
                    private Map.Entry<K, V> current;
                    {
                        this.it = LRUCache.this.cache.entrySet().iterator();
                        this.current = (Map.Entry)NO_ENTRY;
                    }

                    @Override
                    public boolean hasNext() {
                        return (Boolean)LRUCache.this.readOperation(this.it::hasNext);
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return (Map.Entry)LRUCache.this.readOperation(() -> {
                            this.current = this.it.next();
                            return this.current;
                        });
                    }

                    @Override
                    public void remove() {
                        LRUCache.this.writeOperation(() -> {
                            if (this.current == NO_ENTRY) {
                                throw new IllegalStateException("Next not called or already removed");
                            }
                            this.it.remove();
                            this.current = (Map.Entry)NO_ENTRY;
                            return null;
                        });
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.entrySet().toArray());
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return (Object[])LRUCache.this.readOperation(() -> LRUCache.this.cache.entrySet().toArray(a));
            }

            @Override
            public boolean add(Map.Entry<K, V> kvEntry) {
                throw new UnsupportedOperationException("add() not supported on entrySet() of a Map");
            }

            @Override
            public boolean remove(Object o) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.entrySet().remove(o));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return (Boolean)LRUCache.this.readOperation(() -> LRUCache.this.cache.entrySet().containsAll(c));
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException("addAll() not supported on entrySet() of a Map");
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.entrySet().retainAll(c));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return (Boolean)LRUCache.this.writeOperation(() -> LRUCache.this.cache.entrySet().removeAll(c));
            }

            @Override
            public void clear() {
                LRUCache.this.writeOperation(() -> {
                    LRUCache.this.cache.clear();
                    return null;
                });
            }
        });
    }

    private <T> T readOperation(Supplier<T> operation) {
        this.lock.readLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private <T> T writeOperation(Supplier<T> operation) {
        this.lock.writeLock().lock();
        try {
            T t = operation.get();
            return t;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

