/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util.convert;

import com.cedarsoftware.util.convert.Converter;
import com.cedarsoftware.util.convert.InstantConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

final class LocalDateTimeConversions {
    private LocalDateTimeConversions() {
    }

    static ZonedDateTime toZonedDateTime(Object from, Converter converter) {
        return ((LocalDateTime)from).atZone(converter.getOptions().getZoneId());
    }

    static Instant toInstant(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toInstant();
    }

    static long toLong(Object from, Converter converter) {
        return LocalDateTimeConversions.toInstant(from, converter).toEpochMilli();
    }

    static double toDouble(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toDouble(instant, converter);
    }

    static LocalDateTime toLocalDateTime(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalDateTime();
    }

    static LocalDate toLocalDate(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalDate();
    }

    static LocalTime toLocalTime(Object from, Converter converter) {
        return LocalDateTimeConversions.toZonedDateTime(from, converter).toLocalTime();
    }

    static AtomicLong toAtomicLong(Object from, Converter converter) {
        return new AtomicLong(LocalDateTimeConversions.toLong(from, converter));
    }

    static Timestamp toTimestamp(Object from, Converter converter) {
        return new Timestamp(LocalDateTimeConversions.toLong(from, converter));
    }

    static Calendar toCalendar(Object from, Converter converter) {
        ZonedDateTime time = LocalDateTimeConversions.toZonedDateTime(from, converter);
        Calendar calendar = Calendar.getInstance(converter.getOptions().getTimeZone());
        calendar.setTimeInMillis(time.toInstant().toEpochMilli());
        return calendar;
    }

    static java.sql.Date toSqlDate(Object from, Converter converter) {
        return new java.sql.Date(LocalDateTimeConversions.toLong(from, converter));
    }

    static Date toDate(Object from, Converter converter) {
        return new Date(LocalDateTimeConversions.toLong(from, converter));
    }

    static BigInteger toBigInteger(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigInteger(instant, converter);
    }

    static BigDecimal toBigDecimal(Object from, Converter converter) {
        Instant instant = LocalDateTimeConversions.toInstant(from, converter);
        return InstantConversions.toBigDecimal(instant, converter);
    }

    static String toString(Object from, Converter converter) {
        LocalDateTime localDateTime = (LocalDateTime)from;
        return localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }
}

