/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.rules.RamUsageEstimator;
import com.carrotsearch.randomizedtesting.rules.StatementAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import junit.framework.AssertionFailedError;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class StaticFieldsInvariantRule
implements TestRule {
    public static final long DEFAULT_LEAK_THRESHOLD = 0xA00000L;
    private final long leakThreshold;
    private final boolean countSuperclasses;

    public StaticFieldsInvariantRule() {
        this(0xA00000L, true);
    }

    public StaticFieldsInvariantRule(long leakThresholdBytes, boolean countSuperclasses) {
        this.leakThreshold = leakThresholdBytes;
        this.countSuperclasses = countSuperclasses;
    }

    public Statement apply(Statement s, final Description d) {
        return new StatementAdapter(s){

            @Override
            protected void afterAlways(List<Throwable> errors) throws Throwable {
                Class testClass = null;
                try {
                    testClass = RandomizedContext.current().getTargetClass();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (testClass == null) {
                    testClass = d.getTestClass();
                }
                if (testClass == null) {
                    throw new RuntimeException("Test class could not be acquired from the randomized context or the Description object.");
                }
                ArrayList<Entry> fieldsAndValues = new ArrayList<Entry>();
                ArrayList<Object> values = new ArrayList<Object>();
                Class c = testClass;
                while (StaticFieldsInvariantRule.this.countSuperclasses && c.getSuperclass() != null) {
                    Field[] allFields;
                    final Class target = c;
                    for (final Field field : allFields = AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

                        @Override
                        public Field[] run() {
                            return target.getDeclaredFields();
                        }
                    })) {
                        if (!Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive() || !StaticFieldsInvariantRule.this.accept(field)) continue;
                        try {
                            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                                @Override
                                public Void run() {
                                    field.setAccessible(true);
                                    return null;
                                }
                            });
                            Object v = field.get(null);
                            if (v == null) continue;
                            fieldsAndValues.add(new Entry(field, v));
                            values.add(v);
                        }
                        catch (SecurityException e) {
                            errors.add(new RuntimeException("Could not access field '" + field.getName() + "'.", e));
                        }
                    }
                    c = c.getSuperclass();
                }
                long ramUsage = RamUsageEstimator.sizeOfAll(values);
                if (ramUsage > StaticFieldsInvariantRule.this.leakThreshold) {
                    for (Entry e : fieldsAndValues) {
                        e.ramUsed = RamUsageEstimator.sizeOf(e.value);
                    }
                    Collections.sort(fieldsAndValues);
                    StringBuilder b = new StringBuilder();
                    b.append(String.format(Locale.ENGLISH, "Clean up static fields (in @AfterClass?), your test seems to hang on to approximately %,d bytes (threshold is %,d). Field reference sizes (counted individually):", ramUsage, StaticFieldsInvariantRule.this.leakThreshold));
                    for (Entry e : fieldsAndValues) {
                        b.append(String.format(Locale.ENGLISH, "\n  - %,d bytes, %s", e.ramUsed, e.field.toString()));
                    }
                    errors.add((Throwable)new AssertionFailedError(b.toString()));
                }
            }
        };
    }

    protected boolean accept(Field field) {
        return !Modifier.isFinal(field.getModifiers());
    }

    static class Entry
    implements Comparable<Entry> {
        final Field field;
        final Object value;
        long ramUsed;

        public Entry(Field field, Object value) {
            this.field = field;
            this.value = value;
        }

        @Override
        public int compareTo(Entry o) {
            if (this.ramUsed > o.ramUsed) {
                return -1;
            }
            if (this.ramUsed < o.ramUsed) {
                return 1;
            }
            return this.field.toString().compareTo(o.field.toString());
        }
    }
}

