/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting.rules;

import com.carrotsearch.randomizedtesting.ClassModel;
import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class NoShadowingOrOverridesOnMethodsRule
implements TestRule {
    private Class<? extends Annotation>[] annotations;

    @SafeVarargs
    public NoShadowingOrOverridesOnMethodsRule(Class<? extends Annotation> ... annotations) {
        this.annotations = annotations;
    }

    public final Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Class testClass;
                try {
                    testClass = RandomizedContext.current().getTargetClass();
                }
                catch (Throwable t) {
                    testClass = description.getTestClass();
                }
                NoShadowingOrOverridesOnMethodsRule.this.validate(testClass);
                base.evaluate();
            }
        };
    }

    public final void validate(Class<?> clazz) throws Throwable {
        ClassModel classModel = new ClassModel(clazz);
        for (Class<? extends Annotation> annClass : this.annotations) {
            this.checkNoShadowsOrOverrides(clazz, classModel, annClass);
        }
    }

    private void checkNoShadowsOrOverrides(Class<?> clazz, ClassModel classModel, Class<? extends Annotation> ann) {
        Map<Method, ClassModel.MethodModel> annotatedLeafMethods = classModel.getAnnotatedLeafMethods(ann);
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Method, ClassModel.MethodModel> e : annotatedLeafMethods.entrySet()) {
            ClassModel.MethodModel mm;
            if (!this.verify(e.getKey()) || (mm = e.getValue()).getDown() == null && mm.getUp() == null) continue;
            b.append("Methods annotated with @" + ann.getName() + " shadow or override each other:\n");
            while (mm.getUp() != null) {
                mm = (ClassModel.MethodModel)mm.getUp();
            }
            while (mm != null) {
                b.append("  - ");
                if (((Method)mm.element).isAnnotationPresent(ann)) {
                    b.append("@").append(ann.getSimpleName()).append(" ");
                }
                b.append(this.signature((Method)mm.element)).append("\n");
                mm = (ClassModel.MethodModel)mm.getDown();
            }
        }
        if (b.length() > 0) {
            throw new RuntimeException("There are overridden methods annotated with " + ann.getName() + ". These methods would not be executed by JUnit and need to manually chain themselves which can lead to" + " maintenance problems. Consider using different method names or make hook methods private.\n" + b.toString().trim());
        }
    }

    protected boolean verify(Method key) {
        return true;
    }

    private String signature(Method m) {
        return m.toString();
    }
}

