/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.BoundType;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedMultiset;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multiset$Entry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Multisets;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.RegularImmutableSortedSet;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.primitives.Ints;
import java.util.Comparator;
import javax.annotation.Nullable;

final class RegularImmutableSortedMultiset
extends ImmutableSortedMultiset {
    private static final long[] ZERO_CUMULATIVE_COUNTS = new long[]{0L};
    private final transient RegularImmutableSortedSet elementSet;
    private final transient long[] cumulativeCounts;
    private final transient int offset;
    private final transient int length;

    RegularImmutableSortedMultiset(Comparator comparator) {
        this.elementSet = ImmutableSortedSet.emptySet(comparator);
        this.cumulativeCounts = ZERO_CUMULATIVE_COUNTS;
        this.offset = 0;
        this.length = 0;
    }

    RegularImmutableSortedMultiset(RegularImmutableSortedSet regularImmutableSortedSet, long[] lArray, int n, int n2) {
        this.elementSet = regularImmutableSortedSet;
        this.cumulativeCounts = lArray;
        this.offset = n;
        this.length = n2;
    }

    private int getCount(int n) {
        return (int)(this.cumulativeCounts[this.offset + n + 1] - this.cumulativeCounts[this.offset + n]);
    }

    @Override
    Multiset$Entry getEntry(int n) {
        return Multisets.immutableEntry(this.elementSet.asList().get(n), this.getCount(n));
    }

    @Override
    public Multiset$Entry firstEntry() {
        return this.isEmpty() ? null : this.getEntry(0);
    }

    @Override
    public Multiset$Entry lastEntry() {
        return this.isEmpty() ? null : this.getEntry(this.length - 1);
    }

    @Override
    public int count(@Nullable Object object) {
        int n = this.elementSet.indexOf(object);
        return n >= 0 ? this.getCount(n) : 0;
    }

    @Override
    public int size() {
        long l = this.cumulativeCounts[this.offset + this.length] - this.cumulativeCounts[this.offset];
        return Ints.saturatedCast(l);
    }

    @Override
    public ImmutableSortedSet elementSet() {
        return this.elementSet;
    }

    @Override
    public ImmutableSortedMultiset headMultiset(Object object, BoundType boundType) {
        return this.getSubMultiset(0, this.elementSet.headIndex(object, Preconditions.checkNotNull((Object)boundType) == BoundType.CLOSED));
    }

    @Override
    public ImmutableSortedMultiset tailMultiset(Object object, BoundType boundType) {
        return this.getSubMultiset(this.elementSet.tailIndex(object, Preconditions.checkNotNull((Object)boundType) == BoundType.CLOSED), this.length);
    }

    ImmutableSortedMultiset getSubMultiset(int n, int n2) {
        Preconditions.checkPositionIndexes(n, n2, this.length);
        if (n == n2) {
            return RegularImmutableSortedMultiset.emptyMultiset(this.comparator());
        }
        if (n == 0 && n2 == this.length) {
            return this;
        }
        RegularImmutableSortedSet regularImmutableSortedSet = this.elementSet.getSubSet(n, n2);
        return new RegularImmutableSortedMultiset(regularImmutableSortedSet, this.cumulativeCounts, this.offset + n, n2 - n);
    }

    @Override
    boolean isPartialView() {
        return this.offset > 0 || this.length < this.cumulativeCounts.length - 1;
    }
}

