/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.jdbc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptRunnerImpl {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_DELIMITER = ";";

    ScriptRunnerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Connection connection, Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = connection.getAutoCommit();
            try {
                if (originalAutoCommit) {
                    connection.setAutoCommit(false);
                }
                this.doExecute(connection, reader);
            }
            finally {
                connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void doExecute(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            String line;
            String delimiter = DEFAULT_DELIMITER;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--") || trimmedLine.startsWith("#")) {
                    this.log.debug(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.startsWith("--") || trimmedLine.startsWith("#")) continue;
                if (StringUtils.startsWithIgnoreCase((String)trimmedLine, (String)"DELIMITER")) {
                    delimiter = trimmedLine.substring(10).trim();
                    continue;
                }
                if (trimmedLine.endsWith(delimiter)) {
                    command.append(line.substring(0, line.lastIndexOf(delimiter)));
                    Statement statement = conn.createStatement();
                    this.log.debug(command.toString());
                    boolean hasResults = statement.execute(command.toString());
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 1; i <= cols; ++i) {
                            String name = md.getColumnName(i);
                            this.log.debug(name + "\t");
                        }
                        while (rs.next()) {
                            for (i = 1; i <= cols; ++i) {
                                String value = rs.getString(i);
                                this.log.debug(value + "\t");
                            }
                        }
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (SQLException e) {
            e.fillInStackTrace();
            this.log.error("Error executing: " + command, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            this.log.error("Error executing: " + command, (Throwable)e);
            throw e;
        }
    }
}

