/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.jdbc;

import com.carbonfive.db.jdbc.DatabaseType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class DatabaseUtils {
    private static final String POSTGRESQL_FRAGMENT = ":postgresql:";
    private static final String MYSQL_FRAGMENT = ":mysql:";
    private static final String HSQL_FRAGMENT = ":hsqldb:";
    private static final String H2_FRAGMENT = ":h2:";
    private static final String SQL_SERVER_JTDS_FRAGMENT = ":jtds:sqlserver:";
    private static final String SQL_SERVER_MS_2000_FRAGMENT = ":microsoft:sqlserver:";
    private static final String SQL_SERVER_MS_2005_FRAGMENT = ":sqlserver:";
    private static final String DB2_FRAGMENT = ":db2:";
    private static final String ORACLE_FRAGMENT = ":oracle:";

    public static String driverClass(String url) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)url));
        if (url.contains(POSTGRESQL_FRAGMENT)) {
            return "org.postgresql.Driver";
        }
        if (url.contains(MYSQL_FRAGMENT)) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.contains(HSQL_FRAGMENT)) {
            return "org.hsqldb.jdbcDriver";
        }
        if (url.contains(H2_FRAGMENT)) {
            return "org.h2.Driver";
        }
        if (url.contains(SQL_SERVER_JTDS_FRAGMENT)) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (url.contains(SQL_SERVER_MS_2000_FRAGMENT)) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (url.contains(SQL_SERVER_MS_2005_FRAGMENT)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.contains(DB2_FRAGMENT)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (url.contains(ORACLE_FRAGMENT)) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        return null;
    }

    public static DatabaseType databaseType(String url) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)url));
        if (url.contains(POSTGRESQL_FRAGMENT)) {
            return DatabaseType.POSTGRESQL;
        }
        if (url.contains(MYSQL_FRAGMENT)) {
            return DatabaseType.MYSQL;
        }
        if (url.contains(HSQL_FRAGMENT)) {
            return DatabaseType.HSQL;
        }
        if (url.contains(H2_FRAGMENT)) {
            return DatabaseType.H2;
        }
        if (url.contains(SQL_SERVER_JTDS_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(SQL_SERVER_MS_2000_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(SQL_SERVER_MS_2005_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(DB2_FRAGMENT)) {
            return DatabaseType.DB2;
        }
        if (url.contains(ORACLE_FRAGMENT)) {
            return DatabaseType.ORACLE;
        }
        return DatabaseType.UNKNOWN;
    }

    public static String extractDatabaseName(String url) {
        int leftIndex = url.lastIndexOf("/");
        if (leftIndex == -1) {
            leftIndex = url.lastIndexOf(":");
        }
        ++leftIndex;
        int rightIndex = url.length();
        if (url.indexOf("?") != -1) {
            rightIndex = url.indexOf("?");
        } else if (url.indexOf(";") != -1) {
            rightIndex = url.indexOf(";");
        }
        return url.substring(leftIndex, rightIndex);
    }

    public static String extractServerUrl(String url) {
        int rightIndex = url.length();
        if (url.lastIndexOf("/") != -1) {
            rightIndex = url.lastIndexOf("/");
        } else if (url.lastIndexOf(":") != -1) {
            rightIndex = url.lastIndexOf(":");
        }
        String baseUrl = url.substring(0, rightIndex);
        if (DatabaseType.POSTGRESQL.equals((Object)DatabaseUtils.databaseType(url))) {
            baseUrl = baseUrl + "/postgres";
        }
        String options = "";
        int optionsIndex = url.indexOf("?");
        if (optionsIndex == -1) {
            optionsIndex = url.indexOf(";");
        }
        if (optionsIndex != -1) {
            options = url.substring(optionsIndex);
        }
        return baseUrl + options;
    }
}

