/*
 * Decompiled with CFR 0.152.
 */
package com.carbonfive.db.hibernate.repository;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHibernateRepository<T, Id extends Serializable> {
    private Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private SessionFactory sessionFactory;

    public AbstractHibernateRepository() {
    }

    protected AbstractHibernateRepository(SessionFactory sessionFactory) {
        this();
        this.sessionFactory = sessionFactory;
    }

    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    public void flushSession() {
        this.getSession().flush();
    }

    public void clearSession() {
        this.getSession().clear();
    }

    public T findById(Id id, boolean lock) {
        Object entity = lock ? this.getSession().get(this.getPersistentClass(), id, LockMode.UPGRADE) : this.getSession().get(this.getPersistentClass(), id);
        return (T)entity;
    }

    public List<T> findAll() {
        Criteria criteria = this.getSession().createCriteria(this.persistentClass);
        return criteria.list();
    }

    public T makePersistent(T entity) {
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    public void makeTransient(T entity) {
        this.getSession().delete(entity);
    }

    public void makeTransient(Id id) {
        Object entity = this.getSession().get(this.getPersistentClass(), id);
        this.getSession().delete(entity);
    }

    public void refresh(T entity) {
        this.getSession().refresh(entity);
    }

    public T merge(T entity) {
        return (T)this.getSession().merge(entity);
    }

    protected Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

