/*
 * Decompiled with CFR 0.152.
 */
package com.caption.netmonitorlibrary.netStateLib;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import java.util.Locale;

public class NetUtils {
    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager mgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo[] info = mgr.getAllNetworkInfo();
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (info[i].getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isWifiConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mWiFiNetworkInfo;
        if (context != null && (mWiFiNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(1)) != null) {
            return mWiFiNetworkInfo.isAvailable();
        }
        return false;
    }

    public static boolean isMobileConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mMobileNetworkInfo;
        if (context != null && (mMobileNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(0)) != null) {
            return mMobileNetworkInfo.isAvailable();
        }
        return false;
    }

    public static int getConnectedType(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && mNetworkInfo.isAvailable()) {
            return mNetworkInfo.getType();
        }
        return -1;
    }

    public static NetType getAPNType(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return NetType.NONE;
        }
        int nType = networkInfo.getType();
        if (nType == 0) {
            if (networkInfo.getExtraInfo().toLowerCase(Locale.getDefault()).equals("cmnet")) {
                return NetType.CMNET;
            }
            return NetType.CMWAP;
        }
        if (nType == 1) {
            return NetType.WIFI;
        }
        return NetType.NONE;
    }

    public static enum NetType {
        WIFI,
        CMNET,
        CMWAP,
        NONE;

    }
}

