/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.view.ReactClippingViewManager;
import com.facebook.react.views.view.ReactDrawableHelper;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.view.ViewGroupClickEvent;
import com.facebook.yoga.YogaConstants;
import java.util.Locale;
import java.util.Map;

@ReactModule(name="RCTView")
public class ReactViewManager
extends ReactClippingViewManager<ReactViewGroup> {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTView";
    private static final int[] SPACING_TYPES = new int[]{8, 0, 2, 1, 3, 4, 5};
    private static final int CMD_HOTSPOT_UPDATE = 1;
    private static final int CMD_SET_PRESSED = 2;
    private static final String HOTSPOT_UPDATE_KEY = "hotspotUpdate";

    @ReactProp(name="accessible")
    public void setAccessible(ReactViewGroup view, boolean accessible) {
        view.setFocusable(accessible);
    }

    @ReactProp(name="hasTVPreferredFocus")
    public void setTVPreferredFocus(ReactViewGroup view, boolean hasTVPreferredFocus) {
        if (hasTVPreferredFocus) {
            view.setFocusable(true);
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    @ReactProp(name="nextFocusDown", defaultInt=-1)
    public void nextFocusDown(ReactViewGroup view, int viewId) {
        view.setNextFocusDownId(viewId);
    }

    @ReactProp(name="nextFocusForward", defaultInt=-1)
    public void nextFocusForward(ReactViewGroup view, int viewId) {
        view.setNextFocusForwardId(viewId);
    }

    @ReactProp(name="nextFocusLeft", defaultInt=-1)
    public void nextFocusLeft(ReactViewGroup view, int viewId) {
        view.setNextFocusLeftId(viewId);
    }

    @ReactProp(name="nextFocusRight", defaultInt=-1)
    public void nextFocusRight(ReactViewGroup view, int viewId) {
        view.setNextFocusRightId(viewId);
    }

    @ReactProp(name="nextFocusUp", defaultInt=-1)
    public void nextFocusUp(ReactViewGroup view, int viewId) {
        view.setNextFocusUpId(viewId);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius", "borderTopStartRadius", "borderTopEndRadius", "borderBottomStartRadius", "borderBottomEndRadius"}, defaultFloat=NaNf)
    public void setBorderRadius(ReactViewGroup view, int index, float borderRadius) {
        if (!YogaConstants.isUndefined(borderRadius) && borderRadius < 0.0f) {
            borderRadius = Float.NaN;
        }
        if (!YogaConstants.isUndefined(borderRadius)) {
            borderRadius = PixelUtil.toPixelFromDIP(borderRadius);
        }
        if (index == 0) {
            view.setBorderRadius(borderRadius);
        } else {
            view.setBorderRadius(borderRadius, index - 1);
        }
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(ReactViewGroup view, @Nullable String borderStyle) {
        view.setBorderStyle(borderStyle);
    }

    @ReactProp(name="hitSlop")
    public void setHitSlop(ReactViewGroup view, @Nullable ReadableMap hitSlop) {
        if (hitSlop == null) {
            view.setHitSlopRect(null);
        } else {
            view.setHitSlopRect(new Rect(hitSlop.hasKey("left") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("left")) : 0, hitSlop.hasKey("top") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("top")) : 0, hitSlop.hasKey("right") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("right")) : 0, hitSlop.hasKey("bottom") ? (int)PixelUtil.toPixelFromDIP(hitSlop.getDouble("bottom")) : 0));
        }
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(ReactViewGroup view, @Nullable String pointerEventsStr) {
        if (pointerEventsStr == null) {
            view.setPointerEvents(PointerEvents.AUTO);
        } else {
            PointerEvents pointerEvents = PointerEvents.valueOf(pointerEventsStr.toUpperCase(Locale.US).replace("-", "_"));
            view.setPointerEvents(pointerEvents);
        }
    }

    @ReactProp(name="nativeBackgroundAndroid")
    public void setNativeBackground(ReactViewGroup view, @Nullable ReadableMap bg) {
        view.setTranslucentBackgroundDrawable(bg == null ? null : ReactDrawableHelper.createDrawableFromJSDescription(view.getContext(), bg));
    }

    @ReactProp(name="nativeForegroundAndroid")
    @TargetApi(value=23)
    public void setNativeForeground(ReactViewGroup view, @Nullable ReadableMap fg) {
        view.setForeground(fg == null ? null : ReactDrawableHelper.createDrawableFromJSDescription(view.getContext(), fg));
    }

    @ReactProp(name="needsOffscreenAlphaCompositing")
    public void setNeedsOffscreenAlphaCompositing(ReactViewGroup view, boolean needsOffscreenAlphaCompositing) {
        view.setNeedsOffscreenAlphaCompositing(needsOffscreenAlphaCompositing);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(ReactViewGroup view, int index, float width) {
        if (!YogaConstants.isUndefined(width) && width < 0.0f) {
            width = Float.NaN;
        }
        if (!YogaConstants.isUndefined(width)) {
            width = PixelUtil.toPixelFromDIP(width);
        }
        view.setBorderWidth(SPACING_TYPES[index], width);
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor", "borderStartColor", "borderEndColor"}, customType="Color")
    public void setBorderColor(ReactViewGroup view, int index, Integer color) {
        float rgbComponent = color == null ? Float.NaN : (float)(color & 0xFFFFFF);
        float alphaComponent = color == null ? Float.NaN : (float)(color >>> 24);
        view.setBorderColor(SPACING_TYPES[index], rgbComponent, alphaComponent);
    }

    @ReactProp(name="collapsable")
    public void setCollapsable(ReactViewGroup view, boolean collapsable) {
    }

    @ReactProp(name="focusable")
    public void setFocusable(final ReactViewGroup view, boolean focusable) {
        if (focusable) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    EventDispatcher mEventDispatcher = ((ReactContext)view.getContext()).getNativeModule(UIManagerModule.class).getEventDispatcher();
                    mEventDispatcher.dispatchEvent(new ViewGroupClickEvent(view.getId()));
                }
            });
            view.setFocusable(true);
        } else {
            view.setOnClickListener(null);
            view.setClickable(false);
        }
    }

    @ReactProp(name="overflow")
    public void setOverflow(ReactViewGroup view, String overflow) {
        view.setOverflow(overflow);
    }

    @ReactProp(name="backfaceVisibility")
    public void setBackfaceVisibility(ReactViewGroup view, String backfaceVisibility) {
        view.setBackfaceVisibility(backfaceVisibility);
    }

    @Override
    public void setOpacity(@NonNull ReactViewGroup view, float opacity) {
        view.setOpacityIfPossible(opacity);
    }

    @Override
    public void setTransform(@NonNull ReactViewGroup view, @Nullable ReadableArray matrix) {
        super.setTransform(view, matrix);
        view.setBackfaceVisibilityDependantOpacity();
    }

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactViewGroup createViewInstance(ThemedReactContext context) {
        return new ReactViewGroup((Context)context);
    }

    @Override
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of(HOTSPOT_UPDATE_KEY, 1, "setPressed", 2);
    }

    @Override
    public void receiveCommand(ReactViewGroup root, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                this.handleHotspotUpdate(root, args);
                break;
            }
            case 2: {
                this.handleSetPressed(root, args);
            }
        }
    }

    @Override
    public void receiveCommand(ReactViewGroup root, String commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case "hotspotUpdate": {
                this.handleHotspotUpdate(root, args);
                break;
            }
            case "setPressed": {
                this.handleSetPressed(root, args);
            }
        }
    }

    private void handleSetPressed(ReactViewGroup root, @Nullable ReadableArray args) {
        if (args == null || args.size() != 1) {
            throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'setPressed' command");
        }
        root.setPressed(args.getBoolean(0));
    }

    private void handleHotspotUpdate(ReactViewGroup root, @Nullable ReadableArray args) {
        if (args == null || args.size() != 2) {
            throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'updateHotspot' command");
        }
        if (Build.VERSION.SDK_INT >= 21) {
            float x = PixelUtil.toPixelFromDIP(args.getDouble(0));
            float y = PixelUtil.toPixelFromDIP(args.getDouble(1));
            root.drawableHotspotChanged(x, y);
        }
    }
}

