/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.views.text.ReactFontManager;
import java.util.ArrayList;

public class ReactTypefaceUtils {
    public static final int UNSET = -1;

    public static int parseFontWeight(@Nullable String fontWeightString) {
        int fontWeight;
        int fontWeightNumeric = fontWeightString != null ? ReactTypefaceUtils.parseNumericFontWeight(fontWeightString) : -1;
        int n = fontWeight = fontWeightNumeric != -1 ? fontWeightNumeric : 0;
        if (fontWeight == 700 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if (fontWeight == 400 || "normal".equals(fontWeightString)) {
            fontWeight = 0;
        }
        return fontWeight;
    }

    public static int parseFontStyle(@Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        return fontStyle;
    }

    @Nullable
    public static String parseFontVariant(@Nullable ReadableArray fontVariantArray) {
        if (fontVariantArray == null || fontVariantArray.size() == 0) {
            return null;
        }
        ArrayList<String> features = new ArrayList<String>();
        block14: for (int i = 0; i < fontVariantArray.size(); ++i) {
            String fontVariant = fontVariantArray.getString(i);
            if (fontVariant == null) continue;
            switch (fontVariant) {
                case "small-caps": {
                    features.add("'smcp'");
                    continue block14;
                }
                case "oldstyle-nums": {
                    features.add("'onum'");
                    continue block14;
                }
                case "lining-nums": {
                    features.add("'lnum'");
                    continue block14;
                }
                case "tabular-nums": {
                    features.add("'tnum'");
                    continue block14;
                }
                case "proportional-nums": {
                    features.add("'pnum'");
                }
            }
        }
        return TextUtils.join((CharSequence)", ", features);
    }

    public static Typeface applyStyles(@Nullable Typeface typeface, int style2, int weight, @Nullable String family, AssetManager assetManager) {
        int oldStyle = typeface == null ? 0 : typeface.getStyle();
        int want = 0;
        if (weight == 1 || (oldStyle & 1) != 0 && weight == -1) {
            want |= 1;
        }
        if (style2 == 2 || (oldStyle & 2) != 0 && style2 == -1) {
            want |= 2;
        }
        if (family != null) {
            typeface = ReactFontManager.getInstance().getTypeface(family, want, weight, assetManager);
        } else if (typeface != null) {
            typeface = Typeface.create((Typeface)typeface, (int)want);
        }
        if (typeface != null) {
            return typeface;
        }
        return Typeface.defaultFromStyle((int)want);
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }
}

