/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.image;

import android.graphics.Bitmap;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.MultiCacheKey;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.request.Postprocessor;
import java.util.LinkedList;
import java.util.List;

public class MultiPostprocessor
implements Postprocessor {
    private final List<Postprocessor> mPostprocessors;

    public static Postprocessor from(List<Postprocessor> postprocessors) {
        switch (postprocessors.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return postprocessors.get(0);
            }
        }
        return new MultiPostprocessor(postprocessors);
    }

    private MultiPostprocessor(List<Postprocessor> postprocessors) {
        this.mPostprocessors = new LinkedList<Postprocessor>(postprocessors);
    }

    public String getName() {
        StringBuilder name = new StringBuilder();
        for (Postprocessor p : this.mPostprocessors) {
            if (name.length() > 0) {
                name.append(",");
            }
            name.append(p.getName());
        }
        name.insert(0, "MultiPostProcessor (");
        name.append(")");
        return name.toString();
    }

    public CacheKey getPostprocessorCacheKey() {
        LinkedList<CacheKey> keys = new LinkedList<CacheKey>();
        for (Postprocessor p : this.mPostprocessors) {
            keys.push(p.getPostprocessorCacheKey());
        }
        return new MultiCacheKey(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableReference<Bitmap> process(Bitmap sourceBitmap, PlatformBitmapFactory bitmapFactory) {
        CloseableReference prevBitmap = null;
        CloseableReference nextBitmap = null;
        try {
            for (Postprocessor p : this.mPostprocessors) {
                nextBitmap = p.process(prevBitmap != null ? (Bitmap)prevBitmap.get() : sourceBitmap, bitmapFactory);
                CloseableReference.closeSafely(prevBitmap);
                prevBitmap = nextBitmap.clone();
            }
            CloseableReference closeableReference = nextBitmap.clone();
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(nextBitmap);
        }
    }
}

