/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.util;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSStackTrace {
    private static final String LINE_NUMBER_KEY = "lineNumber";
    private static final Pattern FILE_ID_PATTERN = Pattern.compile("\\b((?:seg-\\d+(?:_\\d+)?|\\d+)\\.js)");
    private static final String FILE_KEY = "file";
    private static final String COLUMN_KEY = "column";
    private static final String METHOD_NAME_KEY = "methodName";

    public static String format(String message, ReadableArray stack) {
        StringBuilder stringBuilder = new StringBuilder(message).append(", stack:\n");
        for (int i = 0; i < stack.size(); ++i) {
            ReadableMap frame = stack.getMap(i);
            stringBuilder.append(frame.getString(METHOD_NAME_KEY)).append("@").append(JSStackTrace.parseFileId(frame));
            if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY) && frame.getType(LINE_NUMBER_KEY) == ReadableType.Number) {
                stringBuilder.append(frame.getInt(LINE_NUMBER_KEY));
            } else {
                stringBuilder.append(-1);
            }
            if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY) && frame.getType(COLUMN_KEY) == ReadableType.Number) {
                stringBuilder.append(":").append(frame.getInt(COLUMN_KEY));
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static String parseFileId(ReadableMap frame) {
        Matcher matcher;
        String file;
        if (frame.hasKey(FILE_KEY) && !frame.isNull(FILE_KEY) && frame.getType(FILE_KEY) == ReadableType.String && (file = frame.getString(FILE_KEY)) != null && (matcher = FILE_ID_PATTERN.matcher(file)).find()) {
            return matcher.group(1) + ":";
        }
        return "";
    }
}

