/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.turbomodule.core;

import androidx.annotation.Nullable;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JavaScriptContextHolder;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.turbomodule.core.CallInvokerHolderImpl;
import com.facebook.react.turbomodule.core.TurboModuleManagerDelegate;
import com.facebook.react.turbomodule.core.interfaces.CallInvokerHolder;
import com.facebook.react.turbomodule.core.interfaces.TurboModule;
import com.facebook.react.turbomodule.core.interfaces.TurboModuleRegistry;
import com.facebook.soloader.SoLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TurboModuleManager
implements JSIModule,
TurboModuleRegistry {
    private final TurboModuleManagerDelegate mTurbomoduleManagerDelegate;
    private final Map<String, TurboModule> mTurboModules = new HashMap<String, TurboModule>();
    @DoNotStrip
    private final HybridData mHybridData;

    public TurboModuleManager(JavaScriptContextHolder jsContext, TurboModuleManagerDelegate tmmDelegate, CallInvokerHolder jsCallInvokerHolder, CallInvokerHolder nativeCallInvokerHolder) {
        this.mHybridData = this.initHybrid(jsContext.get(), (CallInvokerHolderImpl)jsCallInvokerHolder, (CallInvokerHolderImpl)nativeCallInvokerHolder, tmmDelegate);
        this.mTurbomoduleManagerDelegate = tmmDelegate;
    }

    @Override
    public List<String> getEagerInitModuleNames() {
        return this.mTurbomoduleManagerDelegate.getEagerInitModuleNames();
    }

    @DoNotStrip
    @Nullable
    protected TurboModule getJavaModule(String name) {
        TurboModule turboModule;
        if (!this.mTurboModules.containsKey(name) && (turboModule = this.mTurbomoduleManagerDelegate.getModule(name)) != null) {
            ((NativeModule)((Object)turboModule)).initialize();
            this.mTurboModules.put(name, turboModule);
        }
        return this.mTurboModules.get(name);
    }

    @Override
    @Nullable
    public TurboModule getModule(String name) {
        return this.getJavaModule(name);
    }

    @Override
    public Collection<TurboModule> getModules() {
        return this.mTurboModules.values();
    }

    @Override
    public boolean hasModule(String name) {
        return this.mTurboModules.containsKey(name);
    }

    private native HybridData initHybrid(long var1, CallInvokerHolderImpl var3, CallInvokerHolderImpl var4, TurboModuleManagerDelegate var5);

    private native void installJSIBindings();

    public void installBindings() {
        this.installJSIBindings();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void onCatalystInstanceDestroy() {
        for (TurboModule turboModule : this.mTurboModules.values()) {
            ((NativeModule)((Object)turboModule)).onCatalystInstanceDestroy();
        }
        this.mTurboModules.clear();
        this.mHybridData.resetNative();
    }

    static {
        SoLoader.loadLibrary((String)"turbomodulejsijni");
    }
}

