/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.react.packagerconnection.JSPackagerClient;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.RequestOnlyHandler;
import com.facebook.react.packagerconnection.Responder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONObject;

public class FileIoHandler
implements Runnable {
    private static final String TAG = JSPackagerClient.class.getSimpleName();
    private static final long FILE_TTL = 30000L;
    private int mNextHandle = 1;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Map<Integer, TtlFileInputStream> mOpenFiles = new HashMap<Integer, TtlFileInputStream>();
    private final Map<String, RequestHandler> mRequestHandlers = new HashMap<String, RequestHandler>();

    public FileIoHandler() {
        this.mRequestHandlers.put("fopen", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(@Nullable Object params, Responder responder) {
                Map map = FileIoHandler.this.mOpenFiles;
                synchronized (map) {
                    try {
                        JSONObject paramsObj = (JSONObject)params;
                        if (paramsObj == null) {
                            throw new Exception("params must be an object { mode: string, filename: string }");
                        }
                        String mode = paramsObj.optString("mode");
                        if (mode == null) {
                            throw new Exception("missing params.mode");
                        }
                        String filename = paramsObj.optString("filename");
                        if (filename == null) {
                            throw new Exception("missing params.filename");
                        }
                        if (!mode.equals("r")) {
                            throw new IllegalArgumentException("unsupported mode: " + mode);
                        }
                        responder.respond(FileIoHandler.this.addOpenFile(filename));
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                }
            }
        });
        this.mRequestHandlers.put("fclose", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(@Nullable Object params, Responder responder) {
                Map map = FileIoHandler.this.mOpenFiles;
                synchronized (map) {
                    try {
                        if (!(params instanceof Number)) {
                            throw new Exception("params must be a file handle");
                        }
                        TtlFileInputStream stream = (TtlFileInputStream)FileIoHandler.this.mOpenFiles.get((int)((Integer)params));
                        if (stream == null) {
                            throw new Exception("invalid file handle, it might have timed out");
                        }
                        FileIoHandler.this.mOpenFiles.remove((int)((Integer)params));
                        stream.close();
                        responder.respond("");
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                }
            }
        });
        this.mRequestHandlers.put("fread", new RequestOnlyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequest(@Nullable Object params, Responder responder) {
                Map map = FileIoHandler.this.mOpenFiles;
                synchronized (map) {
                    try {
                        JSONObject paramsObj = (JSONObject)params;
                        if (paramsObj == null) {
                            throw new Exception("params must be an object { file: handle, size: number }");
                        }
                        int file = paramsObj.optInt("file");
                        if (file == 0) {
                            throw new Exception("invalid or missing file handle");
                        }
                        int size = paramsObj.optInt("size");
                        if (size == 0) {
                            throw new Exception("invalid or missing read size");
                        }
                        TtlFileInputStream stream = (TtlFileInputStream)FileIoHandler.this.mOpenFiles.get(file);
                        if (stream == null) {
                            throw new Exception("invalid file handle, it might have timed out");
                        }
                        responder.respond(stream.read(size));
                    }
                    catch (Exception e) {
                        responder.error(e.toString());
                    }
                }
            }
        });
    }

    public Map<String, RequestHandler> handlers() {
        return this.mRequestHandlers;
    }

    private int addOpenFile(String filename) throws FileNotFoundException {
        int handle = this.mNextHandle++;
        this.mOpenFiles.put(handle, new TtlFileInputStream(filename));
        if (this.mOpenFiles.size() == 1) {
            this.mHandler.postDelayed((Runnable)this, 30000L);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map<Integer, TtlFileInputStream> map = this.mOpenFiles;
        synchronized (map) {
            Iterator<TtlFileInputStream> i = this.mOpenFiles.values().iterator();
            while (i.hasNext()) {
                TtlFileInputStream stream = i.next();
                if (!stream.expiredTtl()) continue;
                i.remove();
                try {
                    stream.close();
                }
                catch (IOException e) {
                    FLog.e((String)TAG, (String)("closing expired file failed: " + e.toString()));
                }
            }
            if (!this.mOpenFiles.isEmpty()) {
                this.mHandler.postDelayed((Runnable)this, 30000L);
            }
        }
    }

    private static class TtlFileInputStream {
        private final FileInputStream mStream;
        private long mTtl;

        public TtlFileInputStream(String path) throws FileNotFoundException {
            this.mStream = new FileInputStream(path);
            this.mTtl = System.currentTimeMillis() + 30000L;
        }

        private void extendTtl() {
            this.mTtl = System.currentTimeMillis() + 30000L;
        }

        public boolean expiredTtl() {
            return System.currentTimeMillis() >= this.mTtl;
        }

        public String read(int size) throws IOException {
            this.extendTtl();
            byte[] buffer = new byte[size];
            int bytesRead = this.mStream.read(buffer);
            return Base64.encodeToString((byte[])buffer, (int)0, (int)bytesRead, (int)0);
        }

        public void close() throws IOException {
            this.mStream.close();
        }
    }
}

