/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromArray;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.ReactBridge;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.ReadableType;
import java.util.ArrayList;
import java.util.Arrays;

@DoNotStrip
public class ReadableNativeArray
extends NativeArray
implements ReadableArray {
    @Nullable
    private Object[] mLocalArray;
    @Nullable
    private ReadableType[] mLocalTypeArray;
    private static int jniPassCounter;

    protected ReadableNativeArray(HybridData hybridData) {
        super(hybridData);
    }

    public static int getJNIPassCounter() {
        return jniPassCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalArray() {
        if (this.mLocalArray != null) {
            return this.mLocalArray;
        }
        ReadableNativeArray readableNativeArray = this;
        synchronized (readableNativeArray) {
            if (this.mLocalArray == null) {
                ++jniPassCounter;
                this.mLocalArray = (Object[])Assertions.assertNotNull((Object)this.importArray());
            }
        }
        return this.mLocalArray;
    }

    private native Object[] importArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadableType[] getLocalTypeArray() {
        if (this.mLocalTypeArray != null) {
            return this.mLocalTypeArray;
        }
        ReadableNativeArray readableNativeArray = this;
        synchronized (readableNativeArray) {
            if (this.mLocalTypeArray == null) {
                ++jniPassCounter;
                Object[] tempArray = (Object[])Assertions.assertNotNull((Object)this.importTypeArray());
                this.mLocalTypeArray = (ReadableType[])Arrays.copyOf(tempArray, tempArray.length, ReadableType[].class);
            }
        }
        return this.mLocalTypeArray;
    }

    private native Object[] importTypeArray();

    @Override
    public int size() {
        return this.getLocalArray().length;
    }

    @Override
    public boolean isNull(int index) {
        return this.getLocalArray()[index] == null;
    }

    @Override
    public boolean getBoolean(int index) {
        return (Boolean)this.getLocalArray()[index];
    }

    @Override
    public double getDouble(int index) {
        return (Double)this.getLocalArray()[index];
    }

    @Override
    public int getInt(int index) {
        return ((Double)this.getLocalArray()[index]).intValue();
    }

    @Override
    @Nullable
    public String getString(int index) {
        return (String)this.getLocalArray()[index];
    }

    @Override
    @Nullable
    public ReadableNativeArray getArray(int index) {
        return (ReadableNativeArray)this.getLocalArray()[index];
    }

    @Override
    @Nullable
    public ReadableNativeMap getMap(int index) {
        return (ReadableNativeMap)this.getLocalArray()[index];
    }

    @Override
    @NonNull
    public ReadableType getType(int index) {
        return this.getLocalTypeArray()[index];
    }

    @Override
    @NonNull
    public Dynamic getDynamic(int index) {
        return DynamicFromArray.create(this, index);
    }

    public int hashCode() {
        return this.getLocalArray().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReadableNativeArray)) {
            return false;
        }
        ReadableNativeArray other = (ReadableNativeArray)obj;
        return Arrays.deepEquals(this.getLocalArray(), other.getLocalArray());
    }

    @Override
    @NonNull
    public ArrayList<Object> toArrayList() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        block8: for (int i = 0; i < this.size(); ++i) {
            switch (this.getType(i)) {
                case Null: {
                    arrayList.add(null);
                    continue block8;
                }
                case Boolean: {
                    arrayList.add(this.getBoolean(i));
                    continue block8;
                }
                case Number: {
                    arrayList.add(this.getDouble(i));
                    continue block8;
                }
                case String: {
                    arrayList.add(this.getString(i));
                    continue block8;
                }
                case Map: {
                    arrayList.add(this.getMap(i).toHashMap());
                    continue block8;
                }
                case Array: {
                    arrayList.add(this.getArray(i).toArrayList());
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Could not convert object at index: " + i + ".");
                }
            }
        }
        return arrayList;
    }

    static {
        ReactBridge.staticInit();
        jniPassCounter = 0;
    }
}

