/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSIModule;
import com.facebook.react.bridge.JSIModuleHolder;
import com.facebook.react.bridge.JSIModuleSpec;
import com.facebook.react.bridge.JSIModuleType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSIModuleRegistry {
    private final Map<JSIModuleType, JSIModuleHolder> mModules = new HashMap<JSIModuleType, JSIModuleHolder>();

    public JSIModule getModule(JSIModuleType moduleType) {
        JSIModuleHolder jsiModuleHolder = this.mModules.get((Object)moduleType);
        if (jsiModuleHolder == null) {
            throw new IllegalArgumentException("Unable to find JSIModule for class " + (Object)((Object)moduleType));
        }
        return (JSIModule)Assertions.assertNotNull((Object)jsiModuleHolder.getJSIModule());
    }

    public void registerModules(List<JSIModuleSpec> jsiModules) {
        for (JSIModuleSpec spec : jsiModules) {
            this.mModules.put(spec.getJSIModuleType(), new JSIModuleHolder(spec));
        }
    }

    public void notifyJSInstanceDestroy() {
        for (Map.Entry<JSIModuleType, JSIModuleHolder> entry : this.mModules.entrySet()) {
            JSIModuleType moduleType = entry.getKey();
            if (moduleType == JSIModuleType.TurboModuleManager) continue;
            JSIModuleHolder moduleHolder = entry.getValue();
            moduleHolder.notifyJSInstanceDestroy();
        }
    }
}

