/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.UIManager;
import java.util.HashMap;
import java.util.Map;

class PropsAnimatedNode
extends AnimatedNode {
    private int mConnectedViewTag = -1;
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final UIManager mUIManager;
    private final Map<String, Integer> mPropNodeMapping;
    private final JavaOnlyMap mPropMap;

    PropsAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager, UIManager uiManager) {
        ReadableMap props = config.getMap("props");
        ReadableMapKeySetIterator iter = props.keySetIterator();
        this.mPropNodeMapping = new HashMap<String, Integer>();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            int nodeIndex = props.getInt(propKey);
            this.mPropNodeMapping.put(propKey, nodeIndex);
        }
        this.mPropMap = new JavaOnlyMap();
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.mUIManager = uiManager;
    }

    public void connectToView(int viewTag) {
        if (this.mConnectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Animated node " + this.mTag + " is already attached to a view");
        }
        this.mConnectedViewTag = viewTag;
    }

    public void disconnectFromView(int viewTag) {
        if (this.mConnectedViewTag != viewTag) {
            throw new JSApplicationIllegalArgumentException("Attempting to disconnect view that has not been connected with the given animated node");
        }
        this.mConnectedViewTag = -1;
    }

    public void restoreDefaultValues() {
        ReadableMapKeySetIterator it = this.mPropMap.keySetIterator();
        while (it.hasNextKey()) {
            this.mPropMap.putNull(it.nextKey());
        }
        this.mUIManager.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, this.mPropMap);
    }

    public final void updateView() {
        if (this.mConnectedViewTag == -1) {
            return;
        }
        for (Map.Entry<String, Integer> entry : this.mPropNodeMapping.entrySet()) {
            AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(entry.getValue());
            if (node == null) {
                throw new IllegalArgumentException("Mapped property node does not exists");
            }
            if (node instanceof StyleAnimatedNode) {
                ((StyleAnimatedNode)node).collectViewUpdates(this.mPropMap);
                continue;
            }
            if (node instanceof ValueAnimatedNode) {
                Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                if (animatedObject instanceof String) {
                    this.mPropMap.putString(entry.getKey(), (String)animatedObject);
                    continue;
                }
                this.mPropMap.putDouble(entry.getKey(), ((ValueAnimatedNode)node).getValue());
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
        }
        this.mUIManager.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, this.mPropMap);
    }
}

