/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.react.ReactAndroidHWInputDeviceHelper;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.deviceinfo.DeviceInfoModule;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.systrace.Systrace;

public class ReactRootView
extends FrameLayout
implements RootView,
ReactRoot {
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private String mJSModuleName;
    @Nullable
    private Bundle mAppProperties;
    @Nullable
    private String mInitialUITemplate;
    @Nullable
    private CustomGlobalLayoutListener mCustomGlobalLayoutListener;
    @Nullable
    private ReactRootViewEventListener mRootViewEventListener;
    private int mRootViewTag;
    private boolean mIsAttachedToInstance;
    private boolean mShouldLogContentAppeared;
    @Nullable
    private JSTouchDispatcher mJSTouchDispatcher;
    private final ReactAndroidHWInputDeviceHelper mAndroidHWInputDeviceHelper = new ReactAndroidHWInputDeviceHelper(this);
    private boolean mWasMeasured = false;
    private int mWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mLastWidth = 0;
    private int mLastHeight = 0;
    private int mUIManagerType = 1;
    private final boolean mUseSurface;

    public ReactRootView(Context context) {
        super(context);
        this.mUseSurface = false;
        this.init();
    }

    public ReactRootView(Context context, boolean useSurface) {
        super(context);
        this.mUseSurface = useSurface;
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mUseSurface = false;
        this.init();
    }

    public ReactRootView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mUseSurface = false;
        this.init();
    }

    private void init() {
        this.setClipChildren(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setAllowImmediateUIOperationExecution(false);
        if (this.mUseSurface) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.setAllowImmediateUIOperationExecution(true);
            return;
        }
        Systrace.beginSection(0L, "ReactRootView.onMeasure");
        try {
            int heightMode;
            boolean measureSpecsUpdated = widthMeasureSpec != this.mWidthMeasureSpec || heightMeasureSpec != this.mHeightMeasureSpec;
            this.mWidthMeasureSpec = widthMeasureSpec;
            this.mHeightMeasureSpec = heightMeasureSpec;
            int width = 0;
            int height = 0;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (widthMode == Integer.MIN_VALUE || widthMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getLeft() + child.getMeasuredWidth() + child.getPaddingLeft() + child.getPaddingRight();
                    width = Math.max(width, childSize);
                }
            } else {
                width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
            if ((heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec)) == Integer.MIN_VALUE || heightMode == 0) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    int childSize = child.getTop() + child.getMeasuredHeight() + child.getPaddingTop() + child.getPaddingBottom();
                    height = Math.max(height, childSize);
                }
            } else {
                height = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
            this.setMeasuredDimension(width, height);
            this.mWasMeasured = true;
            if (this.mReactInstanceManager != null && !this.mIsAttachedToInstance) {
                this.attachToReactInstanceManager();
            } else if (measureSpecsUpdated || this.mLastWidth != width || this.mLastHeight != height) {
                this.updateRootLayoutSpecs(this.mWidthMeasureSpec, this.mHeightMeasureSpec);
            }
            this.mLastWidth = width;
            this.mLastHeight = height;
        }
        finally {
            this.setAllowImmediateUIOperationExecution(true);
            Systrace.endSection(0L);
        }
    }

    @Override
    public void onChildStartedNativeGesture(MotionEvent androidEvent) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.onChildStartedNativeGesture(androidEvent, eventDispatcher);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.dispatchJSTouchEvent(ev);
        super.onTouchEvent(ev);
        return true;
    }

    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDraw(canvas);
        }
        catch (StackOverflowError e) {
            this.handleException(e);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent ev) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle key event as the catalyst instance has not been attached");
            return super.dispatchKeyEvent(ev);
        }
        this.mAndroidHWInputDeviceHelper.handleKeyEvent(ev);
        return super.dispatchKeyEvent(ev);
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle focus changed event as the catalyst instance has not been attached");
            super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
            return;
        }
        this.mAndroidHWInputDeviceHelper.clearFocus();
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
    }

    public void requestChildFocus(View child, View focused) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to handle child focus changed event as the catalyst instance has not been attached");
            super.requestChildFocus(child, focused);
            return;
        }
        this.mAndroidHWInputDeviceHelper.onFocusChanged(focused);
        super.requestChildFocus(child, focused);
    }

    private void dispatchJSTouchEvent(MotionEvent event) {
        if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance || this.mReactInstanceManager.getCurrentReactContext() == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS as the catalyst instance has not been attached");
            return;
        }
        if (this.mJSTouchDispatcher == null) {
            FLog.w((String)"ReactNative", (String)"Unable to dispatch touch to JS before the dispatcher is available");
            return;
        }
        ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
        EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        this.mJSTouchDispatcher.handleTouchEvent(event, eventDispatcher);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (this.getParent() != null) {
            this.getParent().requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mUseSurface) {
            super.onLayout(changed, left, top, right, bottom);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mIsAttachedToInstance) {
            this.removeOnGlobalLayoutListener();
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mIsAttachedToInstance) {
            this.removeOnGlobalLayoutListener();
        }
    }

    private void removeOnGlobalLayoutListener() {
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        if (this.mShouldLogContentAppeared) {
            this.mShouldLogContentAppeared = false;
            if (this.mJSModuleName != null) {
                ReactMarker.logMarker(ReactMarkerConstants.CONTENT_APPEARED, this.mJSModuleName, this.mRootViewTag);
            }
        }
    }

    @Override
    public ViewGroup getRootViewGroup() {
        return this;
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName) {
        this.startReactApplication(reactInstanceManager, moduleName, null);
    }

    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle initialProperties) {
        this.startReactApplication(reactInstanceManager, moduleName, initialProperties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void startReactApplication(ReactInstanceManager reactInstanceManager, String moduleName, @Nullable Bundle initialProperties, @Nullable String initialUITemplate) {
        Systrace.beginSection(0L, "startReactApplication");
        try {
            UiThreadUtil.assertOnUiThread();
            Assertions.assertCondition((this.mReactInstanceManager == null ? 1 : 0) != 0, (String)"This root view has already been attached to a catalyst instance manager");
            this.mReactInstanceManager = reactInstanceManager;
            this.mJSModuleName = moduleName;
            this.mAppProperties = initialProperties;
            this.mInitialUITemplate = initialUITemplate;
            if (this.mUseSurface) {
                // empty if block
            }
            this.mReactInstanceManager.createReactContextInBackground();
            this.attachToReactInstanceManager();
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @Override
    public int getWidthMeasureSpec() {
        return this.mWidthMeasureSpec;
    }

    @Override
    public int getHeightMeasureSpec() {
        return this.mHeightMeasureSpec;
    }

    @Override
    public void setShouldLogContentAppeared(boolean shouldLogContentAppeared) {
        this.mShouldLogContentAppeared = shouldLogContentAppeared;
    }

    @Override
    @Nullable
    public String getSurfaceID() {
        Bundle appProperties = this.getAppProperties();
        return appProperties != null ? appProperties.getString("surfaceID") : null;
    }

    private void updateRootLayoutSpecs(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mReactInstanceManager == null) {
            FLog.w((String)"ReactNative", (String)"Unable to update root layout specs for uninitialized ReactInstanceManager");
            return;
        }
        ReactContext reactApplicationContext = this.mReactInstanceManager.getCurrentReactContext();
        if (reactApplicationContext != null) {
            UIManagerHelper.getUIManager(reactApplicationContext, this.getUIManagerType()).updateRootLayoutSpecs(this.getRootViewTag(), widthMeasureSpec, heightMeasureSpec);
        }
    }

    private void setAllowImmediateUIOperationExecution(boolean flag) {
        ReactInstanceManager reactInstanceManager = this.mReactInstanceManager;
        if (reactInstanceManager == null) {
            return;
        }
        ReactContext reactApplicationContext = reactInstanceManager.getCurrentReactContext();
        if (reactApplicationContext == null) {
            return;
        }
        UIManagerHelper.getUIManager(reactApplicationContext, this.getUIManagerType()).setAllowImmediateUIOperationExecution(flag);
    }

    @ThreadConfined(value="UI")
    public void unmountReactApplication() {
        UiThreadUtil.assertOnUiThread();
        if (this.mReactInstanceManager != null && this.mIsAttachedToInstance) {
            this.mReactInstanceManager.detachRootView(this);
            this.mIsAttachedToInstance = false;
        }
        this.mReactInstanceManager = null;
        this.mShouldLogContentAppeared = false;
    }

    @Override
    public void onStage(int stage) {
        switch (stage) {
            case 101: {
                this.onAttachedToReactInstance();
                break;
            }
        }
    }

    public void onAttachedToReactInstance() {
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
        if (this.mRootViewEventListener != null) {
            this.mRootViewEventListener.onAttachedToReactInstance(this);
        }
    }

    public void setEventListener(ReactRootViewEventListener eventListener) {
        this.mRootViewEventListener = eventListener;
    }

    @Override
    public String getJSModuleName() {
        return (String)Assertions.assertNotNull((Object)this.mJSModuleName);
    }

    @Override
    @Nullable
    public Bundle getAppProperties() {
        return this.mAppProperties;
    }

    @Override
    @Nullable
    public String getInitialUITemplate() {
        return this.mInitialUITemplate;
    }

    @ThreadConfined(value="UI")
    public void setAppProperties(@Nullable Bundle appProperties) {
        UiThreadUtil.assertOnUiThread();
        this.mAppProperties = appProperties;
        if (this.getRootViewTag() != 0) {
            this.runApplication();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runApplication() {
        Systrace.beginSection(0L, "ReactRootView.runApplication");
        try {
            if (this.mReactInstanceManager == null || !this.mIsAttachedToInstance) {
                return;
            }
            ReactContext reactContext = this.mReactInstanceManager.getCurrentReactContext();
            if (reactContext == null) {
                return;
            }
            CatalystInstance catalystInstance = reactContext.getCatalystInstance();
            String jsAppModuleName = this.getJSModuleName();
            if (this.mUseSurface) {
            } else {
                if (this.mWasMeasured) {
                    this.updateRootLayoutSpecs(this.mWidthMeasureSpec, this.mHeightMeasureSpec);
                }
                WritableNativeMap appParams = new WritableNativeMap();
                appParams.putDouble("rootTag", this.getRootViewTag());
                Bundle appProperties = this.getAppProperties();
                if (appProperties != null) {
                    appParams.putMap("initialProps", Arguments.fromBundle(appProperties));
                }
                this.mShouldLogContentAppeared = true;
                catalystInstance.getJSModule(AppRegistry.class).runApplication(jsAppModuleName, appParams);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @VisibleForTesting
    void simulateAttachForTesting() {
        this.mIsAttachedToInstance = true;
        this.mJSTouchDispatcher = new JSTouchDispatcher((ViewGroup)this);
    }

    private CustomGlobalLayoutListener getCustomGlobalLayoutListener() {
        if (this.mCustomGlobalLayoutListener == null) {
            this.mCustomGlobalLayoutListener = new CustomGlobalLayoutListener();
        }
        return this.mCustomGlobalLayoutListener;
    }

    private void attachToReactInstanceManager() {
        Systrace.beginSection(0L, "attachToReactInstanceManager");
        if (this.mIsAttachedToInstance) {
            return;
        }
        try {
            this.mIsAttachedToInstance = true;
            ((ReactInstanceManager)Assertions.assertNotNull((Object)this.mReactInstanceManager)).attachRootView(this);
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.getCustomGlobalLayoutListener());
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Assertions.assertCondition((!this.mIsAttachedToInstance ? 1 : 0) != 0, (String)"The application this ReactRootView was rendering was not unmounted before the ReactRootView was garbage collected. This usually means that your application is leaking large amounts of memory. To solve this, make sure to call ReactRootView#unmountReactApplication in the onDestroy() of your hosting Activity or in the onDestroyView() of your hosting Fragment.");
    }

    @Override
    public int getRootViewTag() {
        return this.mRootViewTag;
    }

    @Override
    public void setRootViewTag(int rootViewTag) {
        this.mRootViewTag = rootViewTag;
    }

    @Override
    public void handleException(Throwable t) {
        if (this.mReactInstanceManager == null || this.mReactInstanceManager.getCurrentReactContext() == null) {
            throw new RuntimeException(t);
        }
        IllegalViewOperationException e = new IllegalViewOperationException(t.getMessage(), (View)this, t);
        this.mReactInstanceManager.getCurrentReactContext().handleException(e);
    }

    public void setIsFabric(boolean isFabric) {
        this.mUIManagerType = isFabric ? 2 : 1;
    }

    @Override
    public int getUIManagerType() {
        return this.mUIManagerType;
    }

    @Nullable
    public ReactInstanceManager getReactInstanceManager() {
        return this.mReactInstanceManager;
    }

    void sendEvent(String eventName, @Nullable WritableMap params) {
        if (this.mReactInstanceManager != null) {
            this.mReactInstanceManager.getCurrentReactContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
        }
    }

    private class CustomGlobalLayoutListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final Rect mVisibleViewArea;
        private final int mMinKeyboardHeightDetected;
        private int mKeyboardHeight = 0;
        private int mDeviceRotation = 0;
        private DisplayMetrics mWindowMetrics = new DisplayMetrics();
        private DisplayMetrics mScreenMetrics = new DisplayMetrics();

        CustomGlobalLayoutListener() {
            DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(ReactRootView.this.getContext().getApplicationContext());
            this.mVisibleViewArea = new Rect();
            this.mMinKeyboardHeightDetected = (int)PixelUtil.toPixelFromDIP(60.0f);
        }

        public void onGlobalLayout() {
            if (ReactRootView.this.mReactInstanceManager == null || !ReactRootView.this.mIsAttachedToInstance || ReactRootView.this.mReactInstanceManager.getCurrentReactContext() == null) {
                return;
            }
            this.checkForKeyboardEvents();
            this.checkForDeviceOrientationChanges();
            this.checkForDeviceDimensionsChanges();
        }

        private void checkForKeyboardEvents() {
            boolean isKeyboardHidden;
            boolean isKeyboardShowingOrKeyboardHeightChanged;
            ReactRootView.this.getRootView().getWindowVisibleDisplayFrame(this.mVisibleViewArea);
            int heightDiff = DisplayMetricsHolder.getWindowDisplayMetrics().heightPixels - this.mVisibleViewArea.bottom;
            boolean bl = isKeyboardShowingOrKeyboardHeightChanged = this.mKeyboardHeight != heightDiff && heightDiff > this.mMinKeyboardHeightDetected;
            if (isKeyboardShowingOrKeyboardHeightChanged) {
                this.mKeyboardHeight = heightDiff;
                ReactRootView.this.sendEvent("keyboardDidShow", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(this.mVisibleViewArea.bottom), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.left), PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), PixelUtil.toDIPFromPixel(this.mKeyboardHeight)));
                return;
            }
            boolean bl2 = isKeyboardHidden = this.mKeyboardHeight != 0 && heightDiff <= this.mMinKeyboardHeightDetected;
            if (isKeyboardHidden) {
                this.mKeyboardHeight = 0;
                ReactRootView.this.sendEvent("keyboardDidHide", this.createKeyboardEventPayload(PixelUtil.toDIPFromPixel(this.mVisibleViewArea.height()), 0.0, PixelUtil.toDIPFromPixel(this.mVisibleViewArea.width()), 0.0));
            }
        }

        private void checkForDeviceOrientationChanges() {
            int rotation = ((WindowManager)ReactRootView.this.getContext().getSystemService("window")).getDefaultDisplay().getRotation();
            if (this.mDeviceRotation == rotation) {
                return;
            }
            this.mDeviceRotation = rotation;
            this.emitOrientationChanged(rotation);
        }

        private void checkForDeviceDimensionsChanges() {
            DisplayMetricsHolder.initDisplayMetrics(ReactRootView.this.getContext());
            if (!this.areMetricsEqual(this.mWindowMetrics, DisplayMetricsHolder.getWindowDisplayMetrics()) || !this.areMetricsEqual(this.mScreenMetrics, DisplayMetricsHolder.getScreenDisplayMetrics())) {
                this.mWindowMetrics.setTo(DisplayMetricsHolder.getWindowDisplayMetrics());
                this.mScreenMetrics.setTo(DisplayMetricsHolder.getScreenDisplayMetrics());
                this.emitUpdateDimensionsEvent();
            }
        }

        private boolean areMetricsEqual(DisplayMetrics displayMetrics, DisplayMetrics otherMetrics) {
            if (Build.VERSION.SDK_INT >= 17) {
                return displayMetrics.equals(otherMetrics);
            }
            return displayMetrics.widthPixels == otherMetrics.widthPixels && displayMetrics.heightPixels == otherMetrics.heightPixels && displayMetrics.density == otherMetrics.density && displayMetrics.densityDpi == otherMetrics.densityDpi && displayMetrics.scaledDensity == otherMetrics.scaledDensity && displayMetrics.xdpi == otherMetrics.xdpi && displayMetrics.ydpi == otherMetrics.ydpi;
        }

        private void emitOrientationChanged(int newRotation) {
            double rotationDegrees;
            String name;
            boolean isLandscape = false;
            switch (newRotation) {
                case 0: {
                    name = "portrait-primary";
                    rotationDegrees = 0.0;
                    break;
                }
                case 1: {
                    name = "landscape-primary";
                    rotationDegrees = -90.0;
                    isLandscape = true;
                    break;
                }
                case 2: {
                    name = "portrait-secondary";
                    rotationDegrees = 180.0;
                    break;
                }
                case 3: {
                    name = "landscape-secondary";
                    rotationDegrees = 90.0;
                    isLandscape = true;
                    break;
                }
                default: {
                    return;
                }
            }
            WritableMap map = Arguments.createMap();
            map.putString("name", name);
            map.putDouble("rotationDegrees", rotationDegrees);
            map.putBoolean("isLandscape", isLandscape);
            ReactRootView.this.sendEvent("namedOrientationDidChange", map);
        }

        private void emitUpdateDimensionsEvent() {
            ReactRootView.this.mReactInstanceManager.getCurrentReactContext().getNativeModule(DeviceInfoModule.class).emitUpdateDimensionsEvent();
        }

        private WritableMap createKeyboardEventPayload(double screenY, double screenX, double width, double height) {
            WritableMap keyboardEventParams = Arguments.createMap();
            WritableMap endCoordinates = Arguments.createMap();
            endCoordinates.putDouble("height", height);
            endCoordinates.putDouble("screenX", screenX);
            endCoordinates.putDouble("width", width);
            endCoordinates.putDouble("screenY", screenY);
            keyboardEventParams.putMap("endCoordinates", endCoordinates);
            keyboardEventParams.putString("easing", "keyboard");
            keyboardEventParams.putDouble("duration", 0.0);
            return keyboardEventParams;
        }
    }

    public static interface ReactRootViewEventListener {
        public void onAttachedToReactInstance(ReactRootView var1);
    }
}

