/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.react.uimanager.FloatUtil;
import com.facebook.yoga.YogaConstants;
import java.util.Arrays;

public class Spacing {
    public static final int LEFT = 0;
    public static final int TOP = 1;
    public static final int RIGHT = 2;
    public static final int BOTTOM = 3;
    public static final int START = 4;
    public static final int END = 5;
    public static final int HORIZONTAL = 6;
    public static final int VERTICAL = 7;
    public static final int ALL = 8;
    private static final int[] sFlagsMap = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256};
    private final float[] mSpacing;
    private int mValueFlags = 0;
    private final float mDefaultValue;
    private boolean mHasAliasesSet;

    public Spacing() {
        this(0.0f);
    }

    public Spacing(float defaultValue) {
        this.mDefaultValue = defaultValue;
        this.mSpacing = Spacing.newFullSpacingArray();
    }

    public Spacing(Spacing original) {
        this.mDefaultValue = original.mDefaultValue;
        this.mSpacing = Arrays.copyOf(original.mSpacing, original.mSpacing.length);
        this.mValueFlags = original.mValueFlags;
        this.mHasAliasesSet = original.mHasAliasesSet;
    }

    public boolean set(int spacingType, float value) {
        if (!FloatUtil.floatsEqual(this.mSpacing[spacingType], value)) {
            this.mSpacing[spacingType] = value;
            this.mValueFlags = YogaConstants.isUndefined(value) ? (this.mValueFlags &= ~sFlagsMap[spacingType]) : (this.mValueFlags |= sFlagsMap[spacingType]);
            this.mHasAliasesSet = (this.mValueFlags & sFlagsMap[8]) != 0 || (this.mValueFlags & sFlagsMap[7]) != 0 || (this.mValueFlags & sFlagsMap[6]) != 0;
            return true;
        }
        return false;
    }

    public float get(int spacingType) {
        float defaultValue;
        float f = defaultValue = spacingType == 4 || spacingType == 5 ? Float.NaN : this.mDefaultValue;
        if (this.mValueFlags == 0) {
            return defaultValue;
        }
        if ((this.mValueFlags & sFlagsMap[spacingType]) != 0) {
            return this.mSpacing[spacingType];
        }
        if (this.mHasAliasesSet) {
            int secondType;
            int n = secondType = spacingType == 1 || spacingType == 3 ? 7 : 6;
            if ((this.mValueFlags & sFlagsMap[secondType]) != 0) {
                return this.mSpacing[secondType];
            }
            if ((this.mValueFlags & sFlagsMap[8]) != 0) {
                return this.mSpacing[8];
            }
        }
        return defaultValue;
    }

    public float getRaw(int spacingType) {
        return this.mSpacing[spacingType];
    }

    public void reset() {
        Arrays.fill(this.mSpacing, Float.NaN);
        this.mHasAliasesSet = false;
        this.mValueFlags = 0;
    }

    float getWithFallback(int spacingType, int fallbackType) {
        return (this.mValueFlags & sFlagsMap[spacingType]) != 0 ? this.mSpacing[spacingType] : this.get(fallbackType);
    }

    private static float[] newFullSpacingArray() {
        return new float[]{Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN};
    }
}

