/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.devsupport.interfaces.StackFrame;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StackTraceHelper {
    public static final String COLUMN_KEY = "column";
    public static final String LINE_NUMBER_KEY = "lineNumber";
    private static final Pattern STACK_FRAME_PATTERN1 = Pattern.compile("^(?:(.*?)@)?(.*?)\\:([0-9]+)\\:([0-9]+)$");
    private static final Pattern STACK_FRAME_PATTERN2 = Pattern.compile("\\s*(?:at)\\s*(.+?)\\s*[@(](.*):([0-9]+):([0-9]+)[)]$");

    public static StackFrame[] convertJsStackTrace(@Nullable ReadableArray stack) {
        int size = stack != null ? stack.size() : 0;
        StackFrame[] result = new StackFrame[size];
        for (int i = 0; i < size; ++i) {
            ReadableType type = stack.getType(i);
            if (type == ReadableType.Map) {
                ReadableMap frame = stack.getMap(i);
                String methodName = frame.getString("methodName");
                String fileName = frame.getString("file");
                int lineNumber = -1;
                if (frame.hasKey(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.hasKey(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                result[i] = new StackFrameImpl(fileName, methodName, lineNumber, columnNumber);
                continue;
            }
            if (type != ReadableType.String) continue;
            result[i] = new StackFrameImpl(null, stack.getString(i), -1, -1);
        }
        return result;
    }

    public static StackFrame[] convertJsStackTrace(JSONArray stack) {
        int size = stack != null ? stack.length() : 0;
        StackFrame[] result = new StackFrame[size];
        try {
            for (int i = 0; i < size; ++i) {
                JSONObject frame = stack.getJSONObject(i);
                String methodName = frame.getString("methodName");
                String fileName = frame.getString("file");
                int lineNumber = -1;
                if (frame.has(LINE_NUMBER_KEY) && !frame.isNull(LINE_NUMBER_KEY)) {
                    lineNumber = frame.getInt(LINE_NUMBER_KEY);
                }
                int columnNumber = -1;
                if (frame.has(COLUMN_KEY) && !frame.isNull(COLUMN_KEY)) {
                    columnNumber = frame.getInt(COLUMN_KEY);
                }
                result[i] = new StackFrameImpl(fileName, methodName, lineNumber, columnNumber);
            }
        }
        catch (JSONException exception) {
            throw new RuntimeException(exception);
        }
        return result;
    }

    public static StackFrame[] convertJsStackTrace(String stack) {
        String[] stackTrace = stack.split("\n");
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            Matcher matcher;
            Matcher matcher1 = STACK_FRAME_PATTERN1.matcher(stackTrace[i]);
            Matcher matcher2 = STACK_FRAME_PATTERN2.matcher(stackTrace[i]);
            if (matcher2.find()) {
                matcher = matcher2;
            } else if (matcher1.find()) {
                matcher = matcher1;
            } else {
                result[i] = new StackFrameImpl(null, stackTrace[i], -1, -1);
                continue;
            }
            result[i] = new StackFrameImpl(matcher.group(2), matcher.group(1) == null ? "(unknown)" : matcher.group(1), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
        }
        return result;
    }

    public static StackFrame[] convertJavaStackTrace(Throwable exception) {
        StackTraceElement[] stackTrace = exception.getStackTrace();
        StackFrame[] result = new StackFrame[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new StackFrameImpl(stackTrace[i].getClassName(), stackTrace[i].getFileName(), stackTrace[i].getMethodName(), stackTrace[i].getLineNumber(), -1);
        }
        return result;
    }

    public static String formatFrameSource(StackFrame frame) {
        StringBuilder lineInfo = new StringBuilder();
        lineInfo.append(frame.getFileName());
        int line = frame.getLine();
        if (line > 0) {
            lineInfo.append(":").append(line);
            int column = frame.getColumn();
            if (column > 0) {
                lineInfo.append(":").append(column);
            }
        }
        return lineInfo.toString();
    }

    public static String formatStackTrace(String title, StackFrame[] stack) {
        StringBuilder stackTrace = new StringBuilder();
        stackTrace.append(title).append("\n");
        for (StackFrame frame : stack) {
            stackTrace.append(frame.getMethod()).append("\n").append("    ").append(StackTraceHelper.formatFrameSource(frame)).append("\n");
        }
        return stackTrace.toString();
    }

    public static class StackFrameImpl
    implements StackFrame {
        private final String mFile;
        private final String mMethod;
        private final int mLine;
        private final int mColumn;
        private final String mFileName;

        private StackFrameImpl(String file, String method, int line, int column) {
            this.mFile = file;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
            this.mFileName = file != null ? new File(file).getName() : "";
        }

        private StackFrameImpl(String file, String fileName, String method, int line, int column) {
            this.mFile = file;
            this.mFileName = fileName;
            this.mMethod = method;
            this.mLine = line;
            this.mColumn = column;
        }

        @Override
        public String getFile() {
            return this.mFile;
        }

        @Override
        public String getMethod() {
            return this.mMethod;
        }

        @Override
        public int getLine() {
            return this.mLine;
        }

        @Override
        public int getColumn() {
            return this.mColumn;
        }

        @Override
        public String getFileName() {
            return this.mFileName;
        }

        @Override
        public JSONObject toJSON() {
            return new JSONObject(MapBuilder.of("file", this.getFile(), "methodName", this.getMethod(), StackTraceHelper.LINE_NUMBER_KEY, this.getLine(), StackTraceHelper.COLUMN_KEY, this.getColumn()));
        }
    }
}

