/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting;

import android.support.annotation.UiThread;
import android.view.View;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.fabric.mounting.ViewPool;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewManagerRegistry;
import java.util.WeakHashMap;

public final class ContextBasedViewPool {
    private final WeakHashMap<ThemedReactContext, ViewPool> mContextViewPoolHashMap = new WeakHashMap();
    private final ViewManagerRegistry mViewManagerRegistry;

    ContextBasedViewPool(ViewManagerRegistry viewManagerRegistry) {
        this.mViewManagerRegistry = viewManagerRegistry;
    }

    @UiThread
    void createView(ThemedReactContext context, String componentName) {
        UiThreadUtil.assertOnUiThread();
        this.getViewPool(context).createView(componentName, context);
    }

    @UiThread
    View getOrCreateView(String componentName, ThemedReactContext context) {
        UiThreadUtil.assertOnUiThread();
        return this.getViewPool(context).getOrCreateView(componentName, context);
    }

    @UiThread
    void returnToPool(ThemedReactContext context, String componentName, View view) {
        UiThreadUtil.assertOnUiThread();
        this.getViewPool(context).returnToPool(componentName, view);
    }

    @UiThread
    private ViewPool getViewPool(ThemedReactContext context) {
        ViewPool pool = this.mContextViewPoolHashMap.get((Object)context);
        if (pool == null) {
            pool = new ViewPool(this.mViewManagerRegistry);
            this.mContextViewPoolHashMap.put(context, pool);
        }
        return pool;
    }
}

