/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.animation.Interpolator;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;

class SimpleSpringInterpolator
implements Interpolator {
    private static final float FACTOR = 0.5f;
    public static final String PARAM_SPRING_DAMPING = "springDamping";
    private final float mSpringDamping;

    public static float getSpringDamping(ReadableMap params) {
        if (params.getType(PARAM_SPRING_DAMPING).equals((Object)ReadableType.Number)) {
            return (float)params.getDouble(PARAM_SPRING_DAMPING);
        }
        return 0.5f;
    }

    public SimpleSpringInterpolator() {
        this.mSpringDamping = 0.5f;
    }

    public SimpleSpringInterpolator(float springDamping) {
        this.mSpringDamping = springDamping;
    }

    public float getInterpolation(float input) {
        return (float)(1.0 + Math.pow(2.0, -10.0f * input) * Math.sin((double)(input - this.mSpringDamping / 4.0f) * Math.PI * 2.0 / (double)this.mSpringDamping));
    }
}

