/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.util.SparseArray;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import javax.annotation.Nullable;

public class ReactEventEmitter
implements RCTEventEmitter {
    private static final String TAG = ReactEventEmitter.class.getSimpleName();
    private final SparseArray<RCTEventEmitter> mEventEmitters = new SparseArray();
    private final ReactApplicationContext mReactContext;

    public ReactEventEmitter(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
    }

    public void register(int uiManagerType, RCTEventEmitter eventEmitter) {
        this.mEventEmitters.put(uiManagerType, (Object)eventEmitter);
    }

    public void unregister(int uiManagerType) {
        this.mEventEmitters.remove(uiManagerType);
    }

    @Override
    public void receiveEvent(int targetReactTag, String eventName, @Nullable WritableMap event) {
        this.getEventEmitter(targetReactTag).receiveEvent(targetReactTag, eventName, event);
    }

    @Override
    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        Assertions.assertCondition((touches.size() > 0 ? 1 : 0) != 0);
        int reactTag = touches.getMap(0).getInt("target");
        this.getEventEmitter(reactTag).receiveTouches(eventName, touches, changedIndices);
    }

    private RCTEventEmitter getEventEmitter(int reactTag) {
        int type = ViewUtil.getUIManagerType(reactTag);
        RCTEventEmitter eventEmitter = (RCTEventEmitter)this.mEventEmitters.get(type);
        if (eventEmitter == null) {
            eventEmitter = this.mReactContext.getJSModule(RCTEventEmitter.class);
        }
        return eventEmitter;
    }
}

