/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.network.OkHttpClientFactory;
import com.facebook.react.modules.network.ReactCookieJarContainer;
import com.facebook.react.modules.network.TLSSocketFactory;
import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;
import okhttp3.Cache;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class OkHttpClientProvider {
    @Nullable
    private static OkHttpClient sClient;
    @Nullable
    private static OkHttpClientFactory sFactory;

    public static void setOkHttpClientFactory(OkHttpClientFactory factory) {
        sFactory = factory;
    }

    public static OkHttpClient getOkHttpClient() {
        if (sClient == null) {
            sClient = OkHttpClientProvider.createClient();
        }
        return sClient;
    }

    public static OkHttpClient createClient() {
        if (sFactory != null) {
            return sFactory.createNewNetworkModuleClient();
        }
        return OkHttpClientProvider.createClientBuilder().build();
    }

    public static OkHttpClient createClient(Context context) {
        if (sFactory != null) {
            return sFactory.createNewNetworkModuleClient();
        }
        return OkHttpClientProvider.createClientBuilder(context).build();
    }

    public static OkHttpClient.Builder createClientBuilder() {
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).cookieJar((CookieJar)new ReactCookieJarContainer());
        try {
            Class<?> ConscryptProvider = Class.forName("org.conscrypt.OpenSSLProvider");
            Security.insertProviderAt((Provider)ConscryptProvider.newInstance(), 1);
            return client;
        }
        catch (Exception e) {
            return OkHttpClientProvider.enableTls12OnPreLollipop(client);
        }
    }

    public static OkHttpClient.Builder createClientBuilder(Context context) {
        int cacheSize = 0xA00000;
        return OkHttpClientProvider.createClientBuilder(context, cacheSize);
    }

    public static OkHttpClient.Builder createClientBuilder(Context context, int cacheSize) {
        OkHttpClient.Builder client = OkHttpClientProvider.createClientBuilder();
        if (cacheSize == 0) {
            return client;
        }
        File cacheDirectory = new File(context.getCacheDir(), "http-cache");
        Cache cache = new Cache(cacheDirectory, (long)cacheSize);
        return client.cache(cache);
    }

    public static OkHttpClient.Builder enableTls12OnPreLollipop(OkHttpClient.Builder client) {
        if (Build.VERSION.SDK_INT <= 19) {
            try {
                client.sslSocketFactory((SSLSocketFactory)new TLSSocketFactory());
                ConnectionSpec cs = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).build();
                ArrayList<ConnectionSpec> specs = new ArrayList<ConnectionSpec>();
                specs.add(cs);
                specs.add(ConnectionSpec.COMPATIBLE_TLS);
                specs.add(ConnectionSpec.CLEARTEXT);
                client.connectionSpecs(specs);
            }
            catch (Exception exc) {
                FLog.e((String)"OkHttpClientProvider", (String)"Error while enabling TLS 1.2", (Throwable)exc);
            }
        }
        return client;
    }
}

