/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSInstance;

public final class CallbackImpl
implements Callback {
    private final JSInstance mJSInstance;
    private final int mCallbackId;
    private boolean mInvoked;

    public CallbackImpl(JSInstance jsInstance, int callbackId) {
        this.mJSInstance = jsInstance;
        this.mCallbackId = callbackId;
        this.mInvoked = false;
    }

    @Override
    public void invoke(Object ... args) {
        if (this.mInvoked) {
            throw new RuntimeException("Illegal callback invocation from native module. This callback type only permits a single invocation from native code.");
        }
        this.mJSInstance.invokeCallback(this.mCallbackId, Arguments.fromJavaArgs(args));
        this.mInvoked = true;
    }
}

