/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import com.facebook.react.LazyReactPackage;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageHelper;
import com.facebook.react.TurboReactPackage;
import com.facebook.react.bridge.ModuleHolder;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.config.ReactFeatureFlags;
import java.util.HashMap;
import java.util.Map;

public class NativeModuleRegistryBuilder {
    private final ReactApplicationContext mReactApplicationContext;
    private final ReactInstanceManager mReactInstanceManager;
    private final Map<String, ModuleHolder> mModules = new HashMap<String, ModuleHolder>();

    public NativeModuleRegistryBuilder(ReactApplicationContext reactApplicationContext, ReactInstanceManager reactInstanceManager) {
        this.mReactApplicationContext = reactApplicationContext;
        this.mReactInstanceManager = reactInstanceManager;
    }

    public void processPackage(ReactPackage reactPackage) {
        Iterable<ModuleHolder> moduleHolders = reactPackage instanceof LazyReactPackage ? ((LazyReactPackage)reactPackage).getNativeModuleIterator(this.mReactApplicationContext) : (reactPackage instanceof TurboReactPackage ? ((TurboReactPackage)reactPackage).getNativeModuleIterator(this.mReactApplicationContext) : ReactPackageHelper.getNativeModuleIterator(reactPackage, this.mReactApplicationContext, this.mReactInstanceManager));
        for (ModuleHolder moduleHolder : moduleHolders) {
            String name = moduleHolder.getName();
            if (this.mModules.containsKey(name)) {
                ModuleHolder existingNativeModule = this.mModules.get(name);
                if (!moduleHolder.getCanOverrideExistingModule()) {
                    throw new IllegalStateException("Native module " + name + " tried to override " + existingNativeModule.getClassName() + " for module name .Check the getPackages() method in MainApplication.java, it might be that module is being created twice. If this was your intention, set canOverrideExistingModule=true");
                }
                this.mModules.remove(existingNativeModule);
            }
            if (ReactFeatureFlags.useTurboModules && moduleHolder.isTurboModule()) continue;
            this.mModules.put(name, moduleHolder);
        }
    }

    public NativeModuleRegistry build() {
        return new NativeModuleRegistry(this.mReactApplicationContext, this.mModules);
    }
}

