package com.bytedance.ttgame.core;

import android.text.TextUtils;

import com.google.gson.annotations.SerializedName;

import org.json.JSONObject;

/**
 * sdk依赖的配置定义,即需要从外部接收的参数
 * 从2100开始，不允许再修改这个类，简单起见，这个就封死在base中了
 */
public class SdkConfig {

    //sdk内部接口使用的chanenlid，代表字节海外渠道
    public static final String BSDK_CHANNEL_ID = "bsdkintl";
    public static final String BYTE_CN_CHANNEL_ID = "bsdk";

    //applog使用的channel，历史原因，线上已经使用这个值做数据统计
    public static final String APPLOG_CHANNEL = "GooglePlay";

    @SerializedName("is_debug")
    public boolean mIsDebug;
    @SerializedName("is_boe")
    public boolean mIsBoe;
    @SerializedName("is_sandbox")
    public boolean mIsSandBox;
    @SerializedName("use_packet_channel")
    public boolean mUsePacketChannel;
    @SerializedName("app_id")
    public String appId;//应用的appId
    @SerializedName("server_region")
    public int serverRegion;//0国内，10新加坡阿里云，20美东
    @SerializedName("gsdk_init_timeout")
    public long gsdkInitTimeout;//
    @SerializedName("channel_data")
    public String channel_data; //这里其实是channel channel_data -> channel
    @SerializedName("channel")
    public String channel; //必须设置,不能为空,这里其实是channel_op  channel->channel_op
    @SerializedName("screen_orientation")
    public String screenOrientation; //sensorLandscape横屏旋转，sensorPortrait，竖屏旋转
    @SerializedName("package_name")
    public String packageName;//应用在应用云平台的真实包名
    @SerializedName("main_activity")
    public String mainActivityName;//主Activity完整包名
    @SerializedName("launch_activity")
    public String launchActivityName;//启动Activity完整包名，若没有则和mainActivityName一样,可选可不填入
    @SerializedName("has_splash")
    public boolean hasSplash;//是否需要启动Splash页面
    @SerializedName("splash_interval")
    public int splashInterval;//Splash间隔时间
    @SerializedName("app_name")
    public String appName;//应用在应用云平台的英文名
    @SerializedName("is_need_visitor")
    public boolean isNeedVisitor = true;//控制本地兜底策略,当开放平台参数请求失败时，是否显示游客登录入口
    @SerializedName("is_private")
    public boolean isPrivate;//是否开启隐私协议强制要求，默认不开启
    @SerializedName("is_need_privacy_protection")
    public boolean isNeedPrivacyProtection; //是否需要游戏隐私弹窗
    @SerializedName("clean_app")
    public boolean cleanApp; //是否是纯净版标记，默认是通用版

    @SerializedName("update_version_code")
    public int updateVersionCode;//相当于小版本号shark风控需要

    @SerializedName("pay_channel")
    public String payChannel;

    @SerializedName("open_launch_trace")
    public boolean openLaunchTrace;

    /**
     * 从 assets 的 config.json 中读取出来的 app 段的原始配置
     * 所有 module 需要的配置都在这里，各个 module 请自行获取和解释
     *
     * * 请各个 module 不要再自己从 assets 中读取 config.json 了 *
     */
    public JSONObject rawConfig;

    /**
     * 获取channel_op字段，一般情况都等于channel字段，只有海外自研渠道需要将GooglePlay转换成bsdkintl
     * GooglePlay和bsdkintl区别:前者为applog使用的channel，后者为海外自研渠道id
     *
     * @return
     */
    public String getChannelOp() {
        return APPLOG_CHANNEL.equals(channel) ? BSDK_CHANNEL_ID : channel;
    }


    /**
     * 有的渠道只有支付，没有登录，所以此时登录模块和支付模块使用的channel不同，
     * 以海外oppo为例，支付时需要传递的channel是oppointl，其他时候传递channel是bsdkintl,
     * 所以json中额外增加一个pay_channel字段，通过getPayChannelOp方法获取，如果不配置，则使用getChannelOp方法的值
     *
     * @return
     */
    public String getPayChannelOp() {
        if (TextUtils.isEmpty(payChannel)) {
            return getChannelOp();
        } else {
            return payChannel;
        }
    }
}
