/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.Context;
import com.bugsnag.android.AppData;
import com.bugsnag.android.Async;
import com.bugsnag.android.Configuration;
import com.bugsnag.android.Error;
import com.bugsnag.android.HttpClient$NetworkException;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Notification;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;

final class ErrorStore {
    private final Configuration config;
    private final String path;

    /*
     * WARNING - void declaration
     */
    ErrorStore(Configuration config, Context appContext) {
        void var1_1;
        String path;
        this.config = config;
        try {
            path = appContext.getCacheDir().getAbsolutePath() + "/bugsnag-errors/";
            File outFile = new File(path);
            outFile.mkdirs();
            if (!outFile.exists()) {
                AppData.warn("Could not prepare error storage directory");
                path = null;
            }
        }
        catch (Exception e) {
            void var2_3;
            AppData.warn("Could not prepare error storage directory", (Throwable)var2_3);
            path = null;
        }
        this.path = var1_1;
    }

    final void flush() {
        if (this.path == null) {
            return;
        }
        Async.run(new Runnable(this){
            private /* synthetic */ ErrorStore this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void run() {
                File exceptionDir = new File(this.this$0.path);
                if (!exceptionDir.exists() || !exceptionDir.isDirectory()) {
                    return;
                }
                File[] errorFiles = exceptionDir.listFiles();
                if (errorFiles != null && errorFiles.length > 0) {
                    void var1_1;
                    AppData.info(String.format("Sending %d saved error(s) to Bugsnag", errorFiles.length));
                    for (void errorFile : var1_1) {
                        try {
                            Notification notif = new Notification(this.this$0.config);
                            notif.addError((File)errorFile);
                            notif.deliver();
                            AppData.info("Deleting sent error file " + errorFile.getName());
                            errorFile.delete();
                        }
                        catch (HttpClient$NetworkException e) {
                            AppData.warn("Could not send previously saved error(s) to Bugsnag, will try again later", e);
                        }
                        catch (Exception e) {
                            AppData.warn("Problem sending unsent error from disk", e);
                            errorFile.delete();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    final void write(Error error) {
        if (this.path == null) {
            return;
        }
        String filename = String.format("%s%d.json", this.path, System.currentTimeMillis());
        FileWriter out = null;
        try {
            JsonStream jsonStream;
            out = new FileWriter(filename);
            JsonStream stream = new JsonStream(out);
            void var5_7 = jsonStream;
            jsonStream = stream;
            var5_7.toStream(jsonStream);
            stream.close();
            AppData.info(String.format("Saved unsent error to disk (%s) ", filename));
        }
        catch (Exception e) {
            try {
                void var2_3;
                AppData.warn(String.format("Couldn't save unsent error to disk (%s) ", var2_3), e);
            }
            catch (Throwable throwable) {
                void var3_4;
                AppData.closeQuietly((Closeable)var3_4);
                throw throwable;
            }
            AppData.closeQuietly(out);
            return;
        }
        AppData.closeQuietly(out);
        return;
    }
}

