/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bugsnag.android.CollectionUtils;
import com.bugsnag.android.ErrorType;
import com.bugsnag.android.JsonStream;
import com.bugsnag.android.Logger;
import com.bugsnag.android.Stackframe;
import com.bugsnag.android.Stacktrace;
import com.bugsnag.android.ThreadInternal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Thread
implements JsonStream.Streamable {
    private final ThreadInternal impl;
    private final Logger logger;

    Thread(String id, @NonNull String name, @NonNull ErrorType type, boolean errorReportingThread, @NonNull State state, @NonNull Logger logger) {
        this.impl = new ThreadInternal(id, name, type, errorReportingThread, state.getDescriptor(), new Stacktrace(new ArrayList<Stackframe>()));
        this.logger = logger;
    }

    Thread(String id, @NonNull String name, @NonNull ErrorType type, boolean errorReportingThread, @NonNull State state, @NonNull Stacktrace stacktrace, @NonNull Logger logger) {
        this.impl = new ThreadInternal(id, name, type, errorReportingThread, state.getDescriptor(), stacktrace);
        this.logger = logger;
    }

    Thread(@NonNull ThreadInternal impl, @NonNull Logger logger) {
        this.impl = impl;
        this.logger = logger;
    }

    private void logNull(String property) {
        this.logger.e("Invalid null value supplied to thread." + property + ", ignoring");
    }

    public void setId(@NonNull String id) {
        if (id != null) {
            this.impl.setId(id);
        } else {
            this.logNull("id");
        }
    }

    @NonNull
    public String getId() {
        return this.impl.getId();
    }

    public void setName(@NonNull String name) {
        if (name != null) {
            this.impl.setName(name);
        } else {
            this.logNull("name");
        }
    }

    @NonNull
    public String getName() {
        return this.impl.getName();
    }

    public void setType(@NonNull ErrorType type) {
        if (type != null) {
            this.impl.setType(type);
        } else {
            this.logNull("type");
        }
    }

    @NonNull
    public ErrorType getType() {
        return this.impl.getType();
    }

    public void setState(@NonNull State threadState) {
        if (threadState != null) {
            this.impl.setState(threadState.getDescriptor());
        } else {
            this.logNull("state");
        }
    }

    @NonNull
    public State getState() {
        return State.byDescriptor(this.impl.getState());
    }

    public boolean getErrorReportingThread() {
        return this.impl.isErrorReportingThread();
    }

    public void setStacktrace(@NonNull List<Stackframe> stacktrace) {
        if (!CollectionUtils.containsNullElements(stacktrace)) {
            this.impl.setStacktrace(stacktrace);
        } else {
            this.logNull("stacktrace");
        }
    }

    @NonNull
    public List<Stackframe> getStacktrace() {
        return this.impl.getStacktrace();
    }

    @NonNull
    public Stackframe addStackframe(@Nullable String method, @Nullable String file, long lineNumber) {
        return this.impl.addStackframe(method, file, lineNumber);
    }

    @Override
    public void toStream(@NonNull JsonStream stream) throws IOException {
        this.impl.toStream(stream);
    }

    public static enum State {
        NEW("NEW"),
        BLOCKED("BLOCKED"),
        RUNNABLE("RUNNABLE"),
        TERMINATED("TERMINATED"),
        TIMED_WAITING("TIMED_WAITING"),
        WAITING("WAITING"),
        UNKNOWN("UNKNOWN");

        private final String descriptor;

        private State(String descriptor) {
            this.descriptor = descriptor;
        }

        @NonNull
        public String getDescriptor() {
            return this.descriptor;
        }

        @NonNull
        public static State forThread(@NonNull java.lang.Thread thread) {
            Thread.State state = thread.getState();
            return State.getState(state);
        }

        @NonNull
        public static State byDescriptor(@Nullable String descriptor) {
            if (descriptor == null) {
                return UNKNOWN;
            }
            for (State state : State.values()) {
                if (!state.getDescriptor().equals(descriptor)) continue;
                return state;
            }
            return UNKNOWN;
        }

        @NonNull
        private static State getState(Thread.State state) {
            switch (state) {
                case NEW: {
                    return NEW;
                }
                case BLOCKED: {
                    return BLOCKED;
                }
                case RUNNABLE: {
                    return RUNNABLE;
                }
                case TERMINATED: {
                    return TERMINATED;
                }
                case TIMED_WAITING: {
                    return TIMED_WAITING;
                }
                case WAITING: {
                    return WAITING;
                }
            }
            return UNKNOWN;
        }
    }
}

