/*
 * Decompiled with CFR 0.152.
 */
package com.bugsnag.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.bugsnag.android.BreadcrumbType;
import com.bugsnag.android.Client;
import com.bugsnag.android.ContextExtensionsKt;
import com.bugsnag.android.Logger;
import com.bugsnag.android.internal.ImmutableConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/bugsnag/android/SystemBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "client", "Lcom/bugsnag/android/Client;", "logger", "Lcom/bugsnag/android/Logger;", "(Lcom/bugsnag/android/Client;Lcom/bugsnag/android/Logger;)V", "actions", "", "", "Lcom/bugsnag/android/BreadcrumbType;", "getActions", "()Ljava/util/Map;", "addExtrasToMetadata", "", "intent", "Landroid/content/Intent;", "meta", "", "", "shortAction", "buildActions", "onReceive", "context", "Landroid/content/Context;", "Companion", "bugsnag-android-core_release"})
public final class SystemBroadcastReceiver
extends BroadcastReceiver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, BreadcrumbType> actions;
    @NotNull
    private static final String INTENT_ACTION_KEY = "Intent Action";

    public SystemBroadcastReceiver(@NotNull Client client, @NotNull Logger logger) {
        this.client = client;
        this.logger = logger;
        this.actions = this.buildActions();
    }

    @NotNull
    public final Map<String, BreadcrumbType> getActions() {
        return this.actions;
    }

    public void onReceive(@NotNull Context context, @NotNull Intent intent) {
        try {
            Map meta = new HashMap();
            String string = intent.getAction();
            if (string == null) {
                return;
            }
            String fullAction = string;
            String shortAction = Companion.shortenActionNameIfNeeded(fullAction);
            Map map2 = meta;
            Object object = INTENT_ACTION_KEY;
            boolean bl = false;
            map2.put(object, fullAction);
            this.addExtrasToMetadata(intent, meta, shortAction);
            object = this.actions.get(fullAction);
            Object type = object == null ? BreadcrumbType.STATE : object;
            this.client.leaveBreadcrumb(shortAction, meta, (BreadcrumbType)((Object)type));
        }
        catch (Exception ex) {
            this.logger.w(Intrinsics.stringPlus((String)"Failed to leave breadcrumb in SystemBroadcastReceiver: ", (Object)ex.getMessage()));
        }
    }

    private final void addExtrasToMetadata(Intent intent, Map<String, Object> meta, String shortAction) {
        Set set;
        Bundle extras = intent.getExtras();
        Bundle bundle = extras;
        if (bundle != null && (set = bundle.keySet()) != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map<String, Object> map2;
                String key = (String)element$iv;
                boolean bl = false;
                Object object = extras.get(key);
                if (object == null) continue;
                Object valObj = object;
                String strVal = valObj.toString();
                if (Companion.isAndroidKey(key)) {
                    map2 = meta;
                    String string = "Extra";
                    String string2 = shortAction + ": " + strVal;
                    boolean bl2 = false;
                    map2.put(string, string2);
                    continue;
                }
                map2 = meta;
                boolean bl3 = false;
                map2.put(key, strVal);
            }
        }
    }

    private final Map<String, BreadcrumbType> buildActions() {
        boolean bl;
        BreadcrumbType breadcrumbType;
        String string;
        Map map2;
        Map actions = new HashMap();
        ImmutableConfig config = this.client.getConfig();
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.USER)) {
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_DELETED";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_DISABLED";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_ENABLED";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.CAMERA_BUTTON";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.CLOSE_SYSTEM_DIALOGS";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.DOCK_EVENT";
            breadcrumbType = BreadcrumbType.USER;
            bl = false;
            map2.put(string, breadcrumbType);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.STATE)) {
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_HOST_RESTORED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_RESTORED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_UPDATE";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.appwidget.action.APPWIDGET_UPDATE_OPTIONS";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.ACTION_POWER_CONNECTED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.ACTION_POWER_DISCONNECTED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.ACTION_SHUTDOWN";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.AIRPLANE_MODE";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.BATTERY_LOW";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.BATTERY_OKAY";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.BOOT_COMPLETED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.CONFIGURATION_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.CONTENT_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.DATE_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.DEVICE_STORAGE_LOW";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.DEVICE_STORAGE_OK";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.INPUT_METHOD_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.LOCALE_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.REBOOT";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.SCREEN_OFF";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.SCREEN_ON";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.TIMEZONE_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.TIME_SET";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.os.action.DEVICE_IDLE_MODE_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.os.action.POWER_SAVE_MODE_CHANGED";
            breadcrumbType = BreadcrumbType.STATE;
            bl = false;
            map2.put(string, breadcrumbType);
        }
        if (!config.shouldDiscardBreadcrumb(BreadcrumbType.NAVIGATION)) {
            map2 = actions;
            string = "android.intent.action.DREAMING_STARTED";
            breadcrumbType = BreadcrumbType.NAVIGATION;
            bl = false;
            map2.put(string, breadcrumbType);
            map2 = actions;
            string = "android.intent.action.DREAMING_STOPPED";
            breadcrumbType = BreadcrumbType.NAVIGATION;
            bl = false;
            map2.put(string, breadcrumbType);
        }
        return actions;
    }

    @JvmStatic
    public static final void register(@NotNull Context ctx, @NotNull SystemBroadcastReceiver receiver, @NotNull Logger logger) {
        Companion.register(ctx, receiver, logger);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/bugsnag/android/SystemBroadcastReceiver$Companion;", "", "()V", "INTENT_ACTION_KEY", "", "isAndroidKey", "", "actionName", "register", "", "ctx", "Landroid/content/Context;", "receiver", "Lcom/bugsnag/android/SystemBroadcastReceiver;", "logger", "Lcom/bugsnag/android/Logger;", "shortenActionNameIfNeeded", "action", "bugsnag-android-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void register(@NotNull Context ctx, @NotNull SystemBroadcastReceiver receiver, @NotNull Logger logger) {
            Map<String, BreadcrumbType> map2 = receiver.getActions();
            boolean bl = false;
            if (!map2.isEmpty()) {
                IntentFilter filter = new IntentFilter();
                Iterable $this$forEach$iv = receiver.getActions().keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p0 = (String)element$iv;
                    boolean bl2 = false;
                    filter.addAction(p0);
                }
                ContextExtensionsKt.registerReceiverSafe(ctx, receiver, filter, logger);
            }
        }

        public final boolean isAndroidKey(@NotNull String actionName) {
            return StringsKt.startsWith$default((String)actionName, (String)"android.", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String shortenActionNameIfNeeded(@NotNull String action) {
            return this.isAndroidKey(action) ? StringsKt.substringAfterLast$default((String)action, (char)'.', null, (int)2, null) : action;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

