/*
 * Decompiled with CFR 0.152.
 */
package com.bugfender.sdk;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import com.bugfender.sdk.LogLevel;
import com.bugfender.sdk.a.a.a.b.b;
import com.bugfender.sdk.a.a.d.c;
import com.bugfender.sdk.a.a.f.f;
import com.bugfender.sdk.a.a.f.g;
import com.bugfender.sdk.a.a.g.c.a;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.UUID;

public class Bugfender {
    private static final String TAG = Bugfender.class.getSimpleName();
    private static com.bugfender.sdk.a.c.a mainThread;
    private static com.bugfender.sdk.a.a.d.b logcatManager;
    private static com.bugfender.sdk.a.a.b loggerManager;
    private static boolean debug;
    private static boolean isCheckBugfenderInitializerLogPrinted;
    private static String apiUrl;

    public static synchronized void init(Context context, String string, boolean bl) {
        if (context == null || TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"WARNING: The bugfender sdk is not initialized. The context or application token provided is null.");
            return;
        }
        if (logcatManager == null) {
            try {
                context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
                if (Bugfender.isMainProcess(context)) {
                    debug = bl;
                    com.bugfender.sdk.a.e.a a2 = new com.bugfender.sdk.a.e.a();
                    com.bugfender.sdk.a.a.i.a a3 = new com.bugfender.sdk.a.a.i.a();
                    b b2 = a2.b();
                    com.bugfender.sdk.a.a.a.b.a a4 = a2.a(b2);
                    com.bugfender.sdk.a.a.a.c.b b3 = a2.a();
                    com.bugfender.sdk.a.a.a.c.a a5 = a2.a(b3);
                    com.bugfender.sdk.a.a.a.a.b b4 = a2.c();
                    com.bugfender.sdk.a.a.a.a.a a6 = a2.a(b4);
                    com.bugfender.sdk.a.a.h.a a7 = a2.a(context, b2, a4, b3, a5, b4, a6);
                    a a8 = a3.a(apiUrl, String.valueOf(20180926), string);
                    apiUrl = null;
                    com.bugfender.sdk.a.a.g.a a9 = new com.bugfender.sdk.a.a.g.a(a8);
                    com.bugfender.sdk.a.a.c.c.a a10 = a2.a(context);
                    com.bugfender.sdk.a.c.b.a a11 = a2.c(context);
                    SharedPreferences sharedPreferences = a2.b(context);
                    com.bugfender.sdk.a.a.c.a.a a12 = a2.a(context, a11, sharedPreferences);
                    com.bugfender.sdk.a.a.e.a<String> a13 = a2.d(context);
                    loggerManager = new com.bugfender.sdk.a.a.b(string, a7, a9, a13, a10, a12);
                    loggerManager.a(0x500000L);
                    com.bugfender.sdk.a.a.d.a a14 = new com.bugfender.sdk.a.a.d.a(context.getPackageName());
                    logcatManager = new c(a14, loggerManager);
                    mainThread = a2.d();
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public static void setMaximumLocalStorageSize(long l) {
        if (Bugfender.isBugfenderInitialized()) {
            if (l < 0L) {
                throw new IllegalArgumentException("The maximum size should be a positive number");
            }
            loggerManager.a(l);
        }
    }

    public static void t(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.d((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.a(string, string2);
            }
        }
    }

    public static void i(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.d((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.b(string, string2);
            }
        }
    }

    public static void d(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.d((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.c(string, string2);
            }
        }
    }

    public static void w(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.w((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.d(string, string2);
            }
        }
    }

    public static void e(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.e((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.e(string, string2);
            }
        }
    }

    public static void f(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                Log.d((String)("BF/" + string), (String)(string2 == null ? "" : string2));
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.f(string, string2);
            }
        }
    }

    public static void log(int n, String string, String string2, LogLevel logLevel, String string3, String string4) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Bugfender.shouldPrintLogcatLog()) {
                switch (logLevel) {
                    case Debug: {
                        Log.d((String)string3, (String)string4);
                        break;
                    }
                    case Warning: {
                        Log.w((String)string3, (String)string4);
                        break;
                    }
                    case Error: {
                        Log.e((String)string3, (String)string4);
                    }
                }
            }
            if (Bugfender.shouldSendBugfenderLog()) {
                loggerManager.a(n, string, string2, g.b.a(logLevel), string3, string4);
            }
        }
    }

    public static UUID sendIssue(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            UUID uUID = loggerManager.g(string, string2);
            loggerManager.a();
            if (debug) {
                Log.e((String)TAG, (String)("Reported issue with Title: " + string + " and Message: " + string2));
            }
            return uUID;
        }
        return null;
    }

    public static void setForceEnabled(boolean bl) {
        if (Bugfender.isBugfenderInitialized()) {
            Bugfender.isBugfenderInitialized();
            loggerManager.a(bl);
            if (debug) {
                Log.i((String)TAG, (String)("Force enable: " + bl));
            }
        }
    }

    public static void forceSendOnce() {
        if (Bugfender.isBugfenderInitialized()) {
            loggerManager.a();
            if (debug) {
                Log.i((String)TAG, (String)"Synchronizing all the logs and issues");
            }
        }
    }

    public static String getDeviceIdentifier() {
        if (Bugfender.isBugfenderInitialized()) {
            return loggerManager.c();
        }
        return null;
    }

    public static String getSessionIdentifier() {
        if (Bugfender.isBugfenderInitialized()) {
            return loggerManager.d();
        }
        return null;
    }

    public static void setDeviceBoolean(String string, boolean bl) {
        if (Bugfender.isBugfenderInitialized()) {
            f<Boolean> f2 = new f<Boolean>(string, bl);
            loggerManager.a(f2);
        }
    }

    public static void setDeviceString(String string, String string2) {
        if (Bugfender.isBugfenderInitialized()) {
            f<String> f2 = new f<String>(string, string2);
            loggerManager.a(f2);
        }
    }

    public static void setDeviceInteger(String string, Integer n) {
        if (Bugfender.isBugfenderInitialized()) {
            f<Integer> f2 = new f<Integer>(string, n);
            loggerManager.a(f2);
        }
    }

    public static void setDeviceFloat(String string, Float f2) {
        if (Bugfender.isBugfenderInitialized()) {
            f<Float> f3 = new f<Float>(string, f2);
            loggerManager.a(f3);
        }
    }

    public static void setApiUrl(String string) {
        try {
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            Log.e((String)TAG, (String)"The custom URL you have passed is malformed. Using default one.");
            return;
        }
        if (!Bugfender.isBugfenderInitialized()) {
            apiUrl = string;
            return;
        }
        Log.w((String)TAG, (String)"WARNING: Bugfender SDK is already initialized. You should call this method before Bugfender.init()");
    }

    public static void removeDeviceKey(String string) {
        if (Bugfender.isBugfenderInitialized()) {
            loggerManager.a(string);
        }
    }

    public static void enableLogcatLogging() {
        if (Bugfender.isBugfenderInitialized()) {
            logcatManager.a();
        }
    }

    public static void enableCrashReporting() {
        if (Bugfender.isBugfenderInitialized()) {
            loggerManager.b();
        }
    }

    public static void disableReflection(boolean bl) {
        if (Bugfender.isBugfenderInitialized()) {
            loggerManager.b(bl);
        }
    }

    @TargetApi(value=14)
    public static void enableUIEventLogging(Application application) {
        if (Bugfender.isBugfenderInitialized()) {
            if (Build.VERSION.SDK_INT >= 14) {
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new com.bugfender.sdk.a.b.a(loggerManager, mainThread, Bugfender.shouldPrintLogcatLog(), Bugfender.shouldSendBugfenderLog()));
            } else {
                Log.e((String)TAG, (String)"It's not possible activate the ui events logging. The minimum SDK is 14.");
            }
        }
    }

    public static void showIssueDialog(Activity activity, final String string, final String string2, String string3, String string4, final IssueDialogCallback issueDialogCallback) {
        com.bugfender.sdk.a.a.c.b.a(Boolean.valueOf(activity == null), (Object)"context == null");
        com.bugfender.sdk.a.a.c.b.a(Boolean.valueOf(string == null), (Object)"title == null");
        com.bugfender.sdk.a.a.c.b.a(Boolean.valueOf(string2 == null), (Object)"description == null");
        new AlertDialog.Builder((Context)activity).setTitle((CharSequence)string).setMessage((CharSequence)string2).setPositiveButton((CharSequence)string4, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                Bugfender.sendIssue(string, string2);
                if (issueDialogCallback != null) {
                    issueDialogCallback.onDialogButtonSendIssueClick();
                }
            }
        }).setNegativeButton((CharSequence)string3, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                if (issueDialogCallback != null) {
                    issueDialogCallback.onDialogDismissed();
                }
            }
        }).create().show();
    }

    private static boolean isBugfenderInitialized() {
        if (loggerManager == null) {
            if (!isCheckBugfenderInitializerLogPrinted) {
                isCheckBugfenderInitializerLogPrinted = true;
                Log.w((String)TAG, (String)"WARNING: Bugfender SDK is not initialized. You should call first to the method Bugfender.init()");
            }
            return false;
        }
        return true;
    }

    private static boolean shouldSendBugfenderLog() {
        return true;
    }

    private static boolean shouldPrintLogcatLog() {
        return !Bugfender.isRelease();
    }

    private static boolean isRelease() {
        return !debug;
    }

    private static boolean isMainProcess(Context context) {
        String string = Bugfender.getProcessName(context);
        if (string == null) {
            Log.w((String)TAG, (String)"WARNING: Bugfender SDK couldn't be initialized.");
        }
        return string != null && context.getPackageName().equals(string);
    }

    private static String getProcessName(Context context) {
        int n = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != n) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return null;
    }

    static {
        isCheckBugfenderInitializerLogPrinted = false;
    }

    public static interface IssueDialogCallback {
        public void onDialogButtonSendIssueClick();

        public void onDialogDismissed();
    }
}

