/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import androidx.annotation.AnyThread;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.WorkerThread;
import com.budiyev.android.imageloader.AsyncLoadImageAction;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.BitmapTransformation;
import com.budiyev.android.imageloader.BitmapTransformationGroup;
import com.budiyev.android.imageloader.DataDescriptor;
import com.budiyev.android.imageloader.DisplayCallback;
import com.budiyev.android.imageloader.DisplayImageAction;
import com.budiyev.android.imageloader.EmptyImageRequestDelegate;
import com.budiyev.android.imageloader.ErrorCallback;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageRequestDelegate;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.InvalidateAction;
import com.budiyev.android.imageloader.LoadCallback;
import com.budiyev.android.imageloader.PauseLock;
import com.budiyev.android.imageloader.PlaceholderDrawable;
import com.budiyev.android.imageloader.RoundedDrawable;
import com.budiyev.android.imageloader.Size;
import com.budiyev.android.imageloader.SyncLoadImageAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;

public final class ImageRequest<T> {
    private static final long DEFAULT_FADE_DURATION = 200L;
    private static final int TRANSFORMATIONS_CAPACITY = 4;
    private final Resources mResources;
    private final ExecutorService mLoadExecutor;
    private final ExecutorService mCacheExecutor;
    private final PauseLock mPauseLock;
    private final Handler mMainThreadHandler;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final BitmapLoader<T> mBitmapLoader;
    private final DataDescriptor<T> mDescriptor;
    private Size mRequiredSize;
    private LoadCallback mLoadCallback;
    private ErrorCallback mErrorCallback;
    private DisplayCallback mDisplayCallback;
    private List<BitmapTransformation> mTransformations;
    private Drawable mPlaceholder;
    private Drawable mErrorDrawable;
    private boolean mFadeEnabled = true;
    private long mFadeDuration = 200L;
    private float mCornerRadius;
    private boolean mMemoryCacheEnabled = true;
    private boolean mStorageCacheEnabled = true;
    private boolean mExecuted;

    ImageRequest(@NonNull Resources resources, @NonNull ExecutorService loadExecutor, @NonNull ExecutorService cacheExecutor, @NonNull PauseLock pauseLock, @NonNull Handler mainThreadHandler, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache, @NonNull BitmapLoader<T> bitmapLoader, @NonNull DataDescriptor<T> descriptor) {
        this.mResources = resources;
        this.mLoadExecutor = loadExecutor;
        this.mCacheExecutor = cacheExecutor;
        this.mPauseLock = pauseLock;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
        this.mBitmapLoader = bitmapLoader;
        this.mMainThreadHandler = mainThreadHandler;
        this.mDescriptor = descriptor;
    }

    @NonNull
    public ImageRequest<T> size(@Nullable Size requiredSize) {
        if (requiredSize != null) {
            this.checkSize(requiredSize.getWidth(), requiredSize.getHeight());
        }
        this.mRequiredSize = requiredSize;
        return this;
    }

    @NonNull
    public ImageRequest<T> size(@Px int requiredWidth, @Px int requiredHeight) {
        this.checkSize(requiredWidth, requiredHeight);
        this.mRequiredSize = new Size(requiredWidth, requiredHeight);
        return this;
    }

    @NonNull
    public ImageRequest<T> roundCorners() {
        this.mCornerRadius = -1.0f;
        return this;
    }

    @NonNull
    public ImageRequest<T> roundCorners(@FloatRange(from=0.0, to=3.4028234663852886E38) float radius) {
        if (radius < 0.0f) {
            throw new IllegalArgumentException("Corner radius should be greater than or equal to zero");
        }
        this.mCornerRadius = radius;
        return this;
    }

    @NonNull
    public ImageRequest<T> placeholder(@Nullable Drawable placeholder) {
        this.mPlaceholder = placeholder;
        return this;
    }

    @NonNull
    public ImageRequest<T> placeholder(@DrawableRes int resId) {
        this.mPlaceholder = this.mResources.getDrawable(resId);
        return this;
    }

    @NonNull
    public ImageRequest<T> errorDrawable(@Nullable Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
        return this;
    }

    @NonNull
    public ImageRequest<T> errorDrawable(@DrawableRes int resId) {
        this.mErrorDrawable = this.mResources.getDrawable(resId);
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(@NonNull BitmapTransformation transformation) {
        this.transformations().add(InternalUtils.requireNonNull(transformation));
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(@NonNull Collection<BitmapTransformation> transformations) {
        this.transformations().addAll(InternalUtils.requireNonNull(transformations));
        return this;
    }

    @NonNull
    public ImageRequest<T> transform(BitmapTransformation ... transformations) {
        Collections.addAll(this.transformations(), (Object[])InternalUtils.requireNonNull(transformations));
        return this;
    }

    @NonNull
    public ImageRequest<T> fade() {
        this.mFadeEnabled = true;
        this.mFadeDuration = 200L;
        return this;
    }

    @NonNull
    public ImageRequest<T> noFade() {
        this.mFadeEnabled = false;
        return this;
    }

    @NonNull
    public ImageRequest<T> fade(@IntRange(from=0L) long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Fade duration should be greater than or equal to zero");
        }
        this.mFadeEnabled = true;
        this.mFadeDuration = duration;
        return this;
    }

    @NonNull
    public ImageRequest<T> onLoaded(@Nullable LoadCallback callback) {
        this.mLoadCallback = callback;
        return this;
    }

    @NonNull
    public ImageRequest<T> onError(@Nullable ErrorCallback callback) {
        this.mErrorCallback = callback;
        return this;
    }

    @NonNull
    public ImageRequest<T> onDisplayed(@Nullable DisplayCallback callback) {
        this.mDisplayCallback = callback;
        return this;
    }

    @NonNull
    public ImageRequest<T> noMemoryCache() {
        this.mMemoryCacheEnabled = false;
        return this;
    }

    @NonNull
    public ImageRequest<T> noStorageCache() {
        this.mStorageCacheEnabled = false;
        return this;
    }

    @Nullable
    @WorkerThread
    public Bitmap loadSync() {
        this.checkAndSetExecutedState();
        return new SyncLoadImageAction<T>(this.mDescriptor, this.mBitmapLoader, this.mRequiredSize, this.getTransformation(), this.getMemoryCache(), this.getStorageCache(), this.mLoadCallback, this.mErrorCallback, this.mPauseLock).load();
    }

    @NonNull
    @AnyThread
    public ImageRequestDelegate load() {
        this.checkAndSetExecutedState();
        return new AsyncLoadImageAction<T>(this.mDescriptor, this.mBitmapLoader, this.mRequiredSize, this.getTransformation(), this.getMemoryCache(), this.getStorageCache(), this.mCacheExecutor, this.mLoadCallback, this.mErrorCallback, this.mPauseLock).submit(this.mLoadExecutor);
    }

    @NonNull
    @MainThread
    public ImageRequestDelegate load(@NonNull View view) {
        Drawable placeholder;
        this.checkAndSetExecutedState();
        Resources resources = this.mResources;
        DataDescriptor<T> descriptor = this.mDescriptor;
        Size requiredSize = this.mRequiredSize;
        BitmapTransformation transformation = this.getTransformation();
        LoadCallback loadCallback = this.mLoadCallback;
        DisplayCallback displayCallback = this.mDisplayCallback;
        ImageCache memoryCache = this.getMemoryCache();
        float cornerRadius = this.mCornerRadius;
        Bitmap image = null;
        String key = InternalUtils.buildFullKey(descriptor.getKey(), requiredSize, transformation);
        if (key != null && memoryCache != null) {
            image = memoryCache.get(key);
        }
        DisplayImageAction<?> currentAction = InternalUtils.getDisplayImageAction(view);
        if (image != null) {
            if (currentAction != null) {
                currentAction.cancel();
            }
            if (loadCallback != null) {
                loadCallback.onLoaded(image);
            }
            if (cornerRadius > 0.0f || cornerRadius == -1.0f) {
                InternalUtils.setDrawable(new RoundedDrawable(resources, image, cornerRadius), view);
            } else {
                InternalUtils.setBitmap(resources, image, view);
            }
            if (displayCallback != null) {
                displayCallback.onDisplayed(image, view);
            }
            return EmptyImageRequestDelegate.INSTANCE;
        }
        if (currentAction != null) {
            if (currentAction.hasSameKey(key) && !currentAction.isCancelled()) {
                return currentAction;
            }
            currentAction.cancel();
        }
        if ((placeholder = this.mPlaceholder) == null) {
            placeholder = new ColorDrawable(0);
        }
        DisplayImageAction<T> action = new DisplayImageAction<T>(resources, view, descriptor, this.mBitmapLoader, requiredSize, transformation, placeholder, this.mErrorDrawable, memoryCache, this.getStorageCache(), this.mCacheExecutor, loadCallback, this.mErrorCallback, displayCallback, this.mPauseLock, this.mMainThreadHandler, this.mFadeEnabled, this.mFadeDuration, cornerRadius);
        InternalUtils.setDrawable((Drawable)new PlaceholderDrawable(placeholder, action), view);
        return action.submit(this.mLoadExecutor);
    }

    @NonNull
    @AnyThread
    public ImageRequestDelegate invalidate() {
        this.checkAndSetExecutedState();
        return new InvalidateAction(this.mDescriptor, this.getMemoryCache(), this.getStorageCache()).submit(this.mCacheExecutor);
    }

    @NonNull
    private List<BitmapTransformation> transformations() {
        List<BitmapTransformation> t = this.mTransformations;
        if (t == null) {
            this.mTransformations = t = new ArrayList<BitmapTransformation>(4);
        }
        return t;
    }

    @Nullable
    private BitmapTransformation getTransformation() {
        List<BitmapTransformation> t = this.mTransformations;
        if (t != null && !t.isEmpty()) {
            if (t.size() == 1) {
                return t.get(0);
            }
            return new BitmapTransformationGroup(t);
        }
        return null;
    }

    @Nullable
    private ImageCache getMemoryCache() {
        return this.mMemoryCacheEnabled ? this.mMemoryCache : null;
    }

    @Nullable
    private ImageCache getStorageCache() {
        return this.mStorageCacheEnabled ? this.mStorageCache : null;
    }

    private void checkAndSetExecutedState() {
        if (this.mExecuted) {
            throw new IllegalStateException("Request can be executed only once");
        }
        this.mExecuted = true;
    }

    private void checkSize(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Width and height should be greater than zero");
        }
    }
}

