/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.imageloader.ByteArrayBitmapLoader;
import com.budiyev.android.imageloader.ByteArrayDataDescriptorFactory;
import com.budiyev.android.imageloader.CompressMode;
import com.budiyev.android.imageloader.FileBitmapLoader;
import com.budiyev.android.imageloader.FileDataDescriptorFactory;
import com.budiyev.android.imageloader.FileDescriptorBitmapLoader;
import com.budiyev.android.imageloader.FileDescriptorDataDescriptorFactory;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoader;
import com.budiyev.android.imageloader.ImageLoaderExecutor;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.MemoryImageCache;
import com.budiyev.android.imageloader.ResourceBitmapLoader;
import com.budiyev.android.imageloader.ResourceDataDescriptorFactory;
import com.budiyev.android.imageloader.StorageImageCache;
import com.budiyev.android.imageloader.StringUriBitmapLoader;
import com.budiyev.android.imageloader.StringUriDataDescriptorFactory;
import com.budiyev.android.imageloader.UriBitmapLoader;
import com.budiyev.android.imageloader.UriDataDescriptorFactory;
import java.io.File;
import java.io.FileDescriptor;
import java.util.concurrent.ExecutorService;

public final class ImageLoaderBuilder {
    private final Context mContext;
    private ImageCache mMemoryCache;
    private ImageCache mStorageCache;
    private ExecutorService mLoadExecutor;
    private ExecutorService mCacheExecutor;

    ImageLoaderBuilder(@NonNull Context context) {
        this.mContext = context;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache() {
        this.mMemoryCache = new MemoryImageCache();
        return this;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache(@IntRange(from=0L) int maxSize) {
        this.mMemoryCache = new MemoryImageCache(maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder memoryCache(@Nullable ImageCache memoryCache) {
        this.mMemoryCache = memoryCache;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache() {
        this.mStorageCache = new StorageImageCache(this.mContext);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@IntRange(from=0L) long maxSize) {
        this.mStorageCache = new StorageImageCache(this.mContext, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull CompressMode compressMode, @IntRange(from=0L) long maxSize) {
        this.mStorageCache = new StorageImageCache(this.mContext, compressMode, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory) {
        this.mStorageCache = new StorageImageCache(directory);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory, @IntRange(from=0L) long maxSize) {
        this.mStorageCache = new StorageImageCache(directory, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@NonNull File directory, @NonNull CompressMode compressMode, long maxSize) {
        this.mStorageCache = new StorageImageCache(directory, compressMode, maxSize);
        return this;
    }

    @NonNull
    public ImageLoaderBuilder storageCache(@Nullable ImageCache storageCache) {
        this.mStorageCache = storageCache;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder loadExecutor(@Nullable ExecutorService executor) {
        this.mLoadExecutor = executor;
        return this;
    }

    @NonNull
    public ImageLoaderBuilder cacheExecutor(@Nullable ExecutorService executor) {
        this.mCacheExecutor = executor;
        return this;
    }

    @NonNull
    public ImageLoader build() {
        ExecutorService cacheExecutor;
        ExecutorService loadExecutor = this.mLoadExecutor;
        if (loadExecutor == null) {
            loadExecutor = new ImageLoaderExecutor(InternalUtils.getLoadPoolSize());
        }
        if ((cacheExecutor = this.mCacheExecutor) == null) {
            cacheExecutor = new ImageLoaderExecutor(InternalUtils.getCachePoolSize());
        }
        Context context = this.mContext;
        ImageLoader loader = new ImageLoader(context, loadExecutor, cacheExecutor, this.mMemoryCache, this.mStorageCache);
        loader.registerDataType(Uri.class, new UriDataDescriptorFactory(), new UriBitmapLoader(context));
        loader.registerDataType(File.class, new FileDataDescriptorFactory(), new FileBitmapLoader());
        loader.registerDataType(String.class, new StringUriDataDescriptorFactory(), new StringUriBitmapLoader(context));
        loader.registerDataType(Integer.class, new ResourceDataDescriptorFactory(), new ResourceBitmapLoader(context));
        loader.registerDataType(FileDescriptor.class, new FileDescriptorDataDescriptorFactory(), new FileDescriptorBitmapLoader());
        loader.registerDataType(byte[].class, new ByteArrayDataDescriptorFactory(), new ByteArrayBitmapLoader());
        return loader;
    }
}

