/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataDescriptorFactory;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageLoaderBuilder;
import com.budiyev.android.imageloader.ImageLoaderHolder;
import com.budiyev.android.imageloader.ImageRequest;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.PauseLock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public final class ImageLoader {
    private final Context mContext;
    private final ExecutorService mLoadExecutor;
    private final ExecutorService mCacheExecutor;
    private final Handler mMainThreadHandler;
    private final ImageCache mMemoryCache;
    private final ImageCache mStorageCache;
    private final PauseLock mPauseLock = new PauseLock();
    private final Map<String, DataDescriptorFactory<Object>> mDescriptorFactories = new ConcurrentHashMap<String, DataDescriptorFactory<Object>>();
    private final Map<String, BitmapLoader<Object>> mBitmapLoaders = new ConcurrentHashMap<String, BitmapLoader<Object>>();

    ImageLoader(@NonNull Context context, @NonNull ExecutorService loadExecutor, @NonNull ExecutorService cacheExecutor, @Nullable ImageCache memoryCache, @Nullable ImageCache storageCache) {
        this.mContext = context;
        this.mLoadExecutor = loadExecutor;
        this.mMainThreadHandler = new Handler(context.getMainLooper());
        this.mCacheExecutor = cacheExecutor;
        this.mMemoryCache = memoryCache;
        this.mStorageCache = storageCache;
    }

    @NonNull
    public <T> ImageRequest<T> from(@NonNull T data) {
        String dataClassName = data.getClass().getName();
        DataDescriptorFactory<Object> descriptorFactory = this.mDescriptorFactories.get(dataClassName);
        BitmapLoader<Object> bitmapLoader = this.mBitmapLoaders.get(dataClassName);
        if (descriptorFactory == null || bitmapLoader == null) {
            throw new IllegalArgumentException("Unsupported data type: " + dataClassName);
        }
        return new ImageRequest<Object>(this.mContext.getResources(), this.mLoadExecutor, this.mCacheExecutor, this.mPauseLock, this.mMainThreadHandler, this.mMemoryCache, this.mStorageCache, bitmapLoader, descriptorFactory.newDescriptor(data));
    }

    public void invalidate(@NonNull Object data) {
        String dataClassName = data.getClass().getName();
        DataDescriptorFactory<Object> descriptorFactory = this.mDescriptorFactories.get(dataClassName);
        if (descriptorFactory == null) {
            throw new IllegalArgumentException("Unsupported data type: " + dataClassName);
        }
        InternalUtils.invalidate(this.mMemoryCache, this.mStorageCache, descriptorFactory.newDescriptor(data));
    }

    public <T> void registerDataType(@NonNull Class<T> dataClass, @NonNull DataDescriptorFactory<T> descriptorFactory, @NonNull BitmapLoader<T> bitmapLoader) {
        String dataClassName = dataClass.getName();
        this.mDescriptorFactories.put(dataClassName, InternalUtils.requireNonNull(descriptorFactory));
        this.mBitmapLoaders.put(dataClassName, InternalUtils.requireNonNull(bitmapLoader));
    }

    public void unregisterDataType(@NonNull Class<?> dataClass) {
        String dataClassName = dataClass.getName();
        this.mDescriptorFactories.remove(dataClassName);
        this.mBitmapLoaders.remove(dataClassName);
    }

    public boolean isLoadingPaused() {
        return this.mPauseLock.isPaused();
    }

    public void setPauseLoading(boolean paused) {
        this.mPauseLock.setPaused(paused);
    }

    public void setInterruptLoadingEarly(boolean interrupt) {
        this.mPauseLock.setInterruptEarly(interrupt);
    }

    public void clearMemoryCache() {
        ImageCache memoryCache = this.mMemoryCache;
        if (memoryCache != null) {
            memoryCache.clear();
        }
    }

    public void clearStorageCache() {
        ImageCache storageCache = this.mStorageCache;
        if (storageCache != null) {
            storageCache.clear();
        }
    }

    public void clearAllCaches() {
        this.clearMemoryCache();
        this.clearStorageCache();
    }

    @NonNull
    public static ImageLoader with(@NonNull Context context) {
        return ImageLoaderHolder.get(context);
    }

    @NonNull
    public static ImageLoaderBuilder builder(@NonNull Context context) {
        return new ImageLoaderBuilder(context);
    }
}

