/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.budiyev.android.imageloader.ImageCache;
import com.budiyev.android.imageloader.ImageRequestAction;
import java.lang.ref.WeakReference;

final class CacheImageAction
extends ImageRequestAction {
    private final String mKey;
    private final WeakReference<Bitmap> mImage;
    private final ImageCache mCache;

    public CacheImageAction(@NonNull String key, @NonNull Bitmap image, @NonNull ImageCache cache) {
        this.mKey = key;
        this.mImage = new WeakReference<Bitmap>(image);
        this.mCache = cache;
    }

    @Override
    protected void execute() {
        Bitmap image;
        if (!this.isCancelled() && (image = (Bitmap)this.mImage.get()) != null) {
            this.mCache.put(this.mKey, image);
        }
    }

    @Override
    protected void onCancelled() {
        this.mImage.clear();
    }
}

