/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import androidx.annotation.NonNull;
import java.io.OutputStream;
import java.util.Arrays;

final class ByteBuffer
extends OutputStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private byte[] mArray;
    private int mSize;

    public ByteBuffer(int initialCapacity) {
        this.mArray = new byte[initialCapacity];
    }

    @Override
    public void write(int b) {
        this.grow(this.mSize + 1);
        this.mArray[this.mSize] = (byte)b;
        ++this.mSize;
    }

    @Override
    public void write(@NonNull byte[] bytes, int offset, int length) {
        this.grow(this.mSize + length);
        System.arraycopy(bytes, offset, this.mArray, this.mSize, length);
        this.mSize += length;
    }

    @NonNull
    public byte[] getArray() {
        return this.mArray;
    }

    public int getSize() {
        return this.mSize;
    }

    private void grow(int capacity) {
        int length = this.mArray.length;
        if (capacity > length) {
            if ((length *= 2) < capacity) {
                length = capacity;
            }
            if (length > 0x7FFFFFF7) {
                length = capacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
            }
            this.mArray = Arrays.copyOf(this.mArray, length);
        }
    }
}

