/*
 * MIT License
 *
 * Copyright (c) 2018 Yuriy Budiyev [yuriy.budiyev@yandex.ru]
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.budiyev.android.imageloader;

/**
 * Encapsulates width and height
 */
public final class Size {
    private final int mWidth;
    private final int mHeight;

    /**
     * Size
     *
     * @param width  Width
     * @param height Height
     */
    public Size(final int width, final int height) {
        mWidth = width;
        mHeight = height;
    }

    /**
     * Width
     */
    public int getWidth() {
        return mWidth;
    }

    /**
     * Height
     */
    public int getHeight() {
        return mHeight;
    }

    @Override
    public int hashCode() {
        return mWidth ^ ((mHeight << (Integer.SIZE / 2)) | (mHeight >>> (Integer.SIZE / 2)));
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj == this) {
            return true;
        } else if (obj instanceof Size) {
            final Size other = (Size) obj;
            return mWidth == other.mWidth && mHeight == other.mHeight;
        } else {
            return false;
        }
    }

    @Override
    public String toString() {
        return mWidth + "x" + mHeight;
    }
}
