/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.budiyev.android.imageloader.BitmapLoader;
import com.budiyev.android.imageloader.DataUtils;
import com.budiyev.android.imageloader.InternalUtils;
import com.budiyev.android.imageloader.Size;
import java.io.InputStream;

final class StringUriBitmapLoader
implements BitmapLoader<String> {
    private final Context mContext;

    public StringUriBitmapLoader(@NonNull Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Bitmap load(@NonNull String data, @Nullable Size requiredSize) throws Throwable {
        int rotation;
        Bitmap bitmap;
        Context context = this.mContext;
        Uri uri = Uri.parse((String)data);
        if (requiredSize != null) {
            bitmap = DataUtils.loadSampledBitmapFromUri(context, uri, requiredSize.getWidth(), requiredSize.getHeight());
        } else {
            InputStream inputStream = null;
            try {
                inputStream = InternalUtils.getDataStreamFromUri(context, uri);
                if (inputStream == null) {
                    Bitmap bitmap2 = null;
                    return bitmap2;
                }
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            }
            finally {
                InternalUtils.close(inputStream);
            }
        }
        if (bitmap != null && InternalUtils.isUriLocal(uri) && (rotation = InternalUtils.getExifRotation(context, uri)) != 0) {
            bitmap = InternalUtils.rotateAndRecycle(bitmap, rotation);
        }
        return bitmap;
    }
}

