/*
 * Decompiled with CFR 0.152.
 */
package com.budiyev.android.imageloader;

import android.support.annotation.NonNull;
import com.budiyev.android.imageloader.ImageLoaderThread;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class ImageLoaderThreadFactory
implements ThreadFactory {
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger(1);
    private static final String THREAD_NAME_PREFIX = "image-loader-";

    ImageLoaderThreadFactory() {
    }

    @Override
    @NonNull
    public Thread newThread(@NonNull Runnable r) {
        return new ImageLoaderThread(r, ImageLoaderThreadFactory.nextThreadName());
    }

    @NonNull
    private static String nextThreadName() {
        THREAD_COUNTER.compareAndSet(Integer.MAX_VALUE, 1);
        return THREAD_NAME_PREFIX + THREAD_COUNTER.getAndIncrement();
    }
}

